/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.access.Access;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.CollectionInfo;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.UsersI;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.misc.Util;

class Users
extends CalSvcDb
implements UsersI {
    private BwPrincipal<?> publicUser;
    private final Map<String, BwPrincipal<?>> principalMap = new HashMap();
    private long lastFlush = System.currentTimeMillis();
    private static final long flushInt = 150000L;
    private static String principalRoot;
    private static String userPrincipalRoot;
    private static String groupPrincipalRoot;
    private static int groupPrincipalRootLen;

    Users(CalSvc svci) {
        super(svci);
    }

    public BwPrincipal<?> getUser(String account) {
        if (account == null) {
            return null;
        }
        Users.setRoots(this.getSvc());
        String href = this.getSvc().getDirectories().makePrincipalUri(account, 1);
        return this.getPrincipal(href);
    }

    public BwPrincipal<?> getAlways(String account) {
        if (account == null) {
            return BwPrincipal.makeUserPrincipal();
        }
        BwPrincipal<?> u = this.getUser(account);
        if (u == null) {
            if (account.endsWith("/")) {
                account = account.substring(0, account.length() - 1);
            }
            this.add(account);
        }
        return this.getUser(account);
    }

    private static void setRoots(CalSvcI svc) {
        if (principalRoot != null) {
            return;
        }
        DirectoryInfo di = svc.getDirectories().getDirectoryInfo();
        principalRoot = di.getPrincipalRoot();
        userPrincipalRoot = di.getUserPrincipalRoot();
        groupPrincipalRoot = di.getGroupPrincipalRoot();
        groupPrincipalRootLen = groupPrincipalRoot.length();
    }

    private BwPrincipal<?> mappedPrincipal(String val) {
        long now = System.currentTimeMillis();
        if (now - this.lastFlush > 150000L) {
            this.principalMap.clear();
            this.lastFlush = now;
            return null;
        }
        return this.principalMap.get(val);
    }

    public BwPrincipal<?> getPrincipal(String val) {
        if (val == null) {
            throw new RuntimeException("getPrincipal: param cannot be null");
        }
        String href = val.endsWith("/") ? val.substring(0, val.length() - 1) : val;
        BwPrincipal<?> p = this.mappedPrincipal(href);
        if (p != null) {
            return p;
        }
        Users.setRoots(this.getSvc());
        if (!href.startsWith(principalRoot)) {
            return null;
        }
        if (href.startsWith(userPrincipalRoot)) {
            BwPrincipal<?> u = this.getSvc().getPrincipal(href);
            if (u != null) {
                this.principalMap.put(href, u);
            }
            return u;
        }
        if (href.startsWith(groupPrincipalRoot)) {
            BwGroup g = this.getSvc().getDirectories().findGroup(href.substring(groupPrincipalRootLen));
            if (g != null) {
                this.principalMap.put(href, (BwPrincipal<?>)g);
            }
            return g;
        }
        return null;
    }

    public void add(String val) {
        this.principalMap.clear();
        this.getSvc().addUser(val);
    }

    BwPrincipal<?> initUserObject(String val) {
        String account = val;
        if (account.endsWith("/")) {
            account = account.substring(0, account.length() - 1);
        }
        if (this.getSvc().getDirectories().isPrincipal(val)) {
            account = this.getSvc().getDirectories().accountFromPrincipal(val);
        }
        if (account == null) {
            throw new BedeworkException("Bad user account " + val);
        }
        Users.setRoots(this.getSvc());
        BwPrincipal user = BwPrincipal.makeUserPrincipal();
        user.setAccount(account);
        user.setCategoryAccess(Access.getDefaultPersonalAccess());
        user.setLocationAccess(Access.getDefaultPersonalAccess());
        user.setContactAccess(Access.getDefaultPersonalAccess());
        user.setQuota(this.getSvc().getAuthProperties().getDefaultUserQuota());
        user.setPrincipalRef(Util.buildPath((boolean)false, (String[])new String[]{userPrincipalRoot, "/", account}));
        return user;
    }

    void createUser(String val) {
        BwPrincipal<?> user = this.initUserObject(val);
        Users.setRoots(this.getSvc());
        this.getCal().add(user);
        this.getSvc().initPrincipal(user);
        this.initPrincipal(user, this.getSvc());
        for (CollectionInfo ci : BwCalendar.getAllCollectionInfo()) {
            if (!ci.provision) continue;
            this.getCal().getSpecialCalendar(null, user, ci.collectionType, true, 25);
        }
        this.getSvc().postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.NEW_USER, (String)user.getPrincipalRef(), (long)0L));
    }

    public void update(BwPrincipal<?> principal) {
        this.getCal().update(principal);
    }

    public void remove(BwPrincipal<?> pr) {
        BwCalendar home;
        String userRoot = this.getSvc().getPrincipalInfo().getCalendarHomePath(pr);
        Collection views = this.getSvc().getViewsHandler().getAll(pr);
        for (BwView view : views) {
            this.getSvc().getViewsHandler().remove(view);
        }
        BwPreferences prefs = this.getPrefs(pr);
        if (prefs != null) {
            prefs.setDefaultCalendarPath(null);
            this.getSvc().getPrefsHandler().update(prefs);
        }
        if ((home = this.getSvc().getCalendarsHandler().get(userRoot)) != null) {
            ((Calendars)this.getCols()).delete(home, true, true, false, true);
        }
        this.getSvc().getPrefsHandler().delete(prefs);
        this.getCal().getIndexer("principal").unindexEntity(pr.getHref());
    }

    public void logon(BwPrincipal<?> val) {
        if (!this.getPars().getReadonly()) {
            this.getSvc().getCal().getSpecialCalendar(null, val, 12, true, 25);
        }
    }

    public void initPrincipal(BwPrincipal<?> principal) {
        this.initPrincipal(principal, this.getSvc());
    }

    private void initPrincipal(BwPrincipal<?> principal, CalSvc svc) {
        BwPreferences prefs = new BwPreferences();
        prefs.setOwnerHref(principal.getPrincipalRef());
        prefs.setPublick(Boolean.valueOf(false));
        prefs.setDefaultCalendarPath(Util.buildPath((boolean)false, (String[])new String[]{this.getSvc().getPrincipalInfo().getCalendarHomePath(principal), "/", "calendar"}));
        BwView view = new BwView();
        AuthProperties authPars = this.getSvc().getAuthProperties();
        view.setName(authPars.getDefaultUserViewName());
        view.addCollectionPath(svc.getPrincipalInfo().getCalendarHomePath(principal));
        prefs.addView(view);
        prefs.setPreferredView(view.getName());
        prefs.setPreferredViewPeriod("week");
        prefs.setHour24(authPars.getDefaultUserHour24());
        prefs.setScheduleAutoRespond(principal.getKind() == 5);
        if (this.isTestUser(principal)) {
            prefs.setScheduleAutoProcessResponses(BwPreferences.scheduleAutoProcessResponsesNotifyAll);
        }
        this.getSvc().getPrefsHandler().add(prefs);
    }

    private boolean isTestUser(BwPrincipal<?> pr) {
        if (pr.getKind() != 1) {
            return false;
        }
        String account = pr.getAccount();
        if (!account.startsWith("user")) {
            return false;
        }
        try {
            Integer.parseInt(account.substring(4));
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public BwPrincipal<?> getPublicUser() {
        if (this.publicUser == null) {
            this.publicUser = this.getUser("public-user");
        }
        if (this.publicUser == null) {
            throw new RuntimeException("No guest user proxy account - expected public-user");
        }
        return this.publicUser;
    }

    public List<String> getPrincipalHrefs(int start, int count) {
        return this.getCal().getPrincipalHrefs(start, count);
    }
}

