/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.BedeworkForbidden;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.util.misc.Util;

class ResourcesImpl
extends CalSvcDb
implements ResourcesI {
    ResourcesImpl(CalSvc svci) {
        super(svci);
    }

    public boolean saveNotification(BwResource val) {
        return this.save(val, true, true);
    }

    public boolean save(BwResource val, boolean returnIfExists) {
        return this.save(val, false, returnIfExists);
    }

    public BwResource get(String path) {
        return this.getCal().getResource(path, 1);
    }

    public void getContent(BwResource val) {
        this.getCal().getResourceContent(val);
    }

    public List<BwResource> getAll(String path) {
        return this.getCal().getResources(path, false, null, -1);
    }

    public List<BwResource> get(String path, int count) {
        return this.getCal().getResources(path, false, null, count);
    }

    public void update(BwResource val, boolean updateContent) {
        this.checkAccess((ShareableEntity)val, 5, false);
        try {
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().update(val);
            if (updateContent && val.getContent() != null) {
                BwResourceContent rc = val.getContent();
                rc.setColPath(val.getColPath());
                rc.setName(val.getName());
                this.getCal().updateContent(val, rc);
            }
            this.getSvc().touchCalendar(this.getCols().get(val.getColPath()));
        }
        catch (BedeworkException be) {
            this.getSvc().rollbackTransaction();
            throw be;
        }
    }

    public void delete(String path) {
        this.getCal().deleteResource(path);
    }

    public boolean copyMove(BwResource val, String to, String name, boolean copy, boolean overwrite) {
        try {
            this.getSvc().setupSharableEntity((ShareableEntity)val, this.getPrincipal().getPrincipalRef());
            BwCalendar collTo = this.getCols().get(to);
            if (collTo == null) {
                throw new BedeworkException("org.bedework.exception.calendarnotfound", to);
            }
            if (collTo.getCalType() != 0) {
                throw new BedeworkException("org.bedework.exception.badrequest", to);
            }
            int access = copy ? 5 : 9;
            this.checkAccess((ShareableEntity)collTo, access, false);
            BwResource r = this.getCal().getResource(Util.buildPath((boolean)false, (String[])new String[]{to, "/", val.getName()}), access);
            boolean createdNew = false;
            this.getContent(val);
            if (r != null) {
                if (!overwrite) {
                    throw new BedeworkException("org.bedework.exception.targetexists", val.getName());
                }
                this.getContent(r);
                r.setContentType(val.getContentType());
                r.setContentLength(val.getContentLength());
                r.updateLastmod(this.getCurrentTimestamp());
                BwResourceContent rc = r.getContent();
                rc.setByteValue(val.getContent().getByteValue());
                this.getCal().update(r);
                this.getCal().updateContent(r, rc);
            } else {
                r = new BwResource();
                this.getSvc().setupSharableEntity((ShareableEntity)r, this.getPrincipal().getPrincipalRef());
                r.setName(name);
                r.setColPath(collTo.getPath());
                r.setContentType(val.getContentType());
                r.setContentLength(val.getContentLength());
                r.updateLastmod(this.getCurrentTimestamp());
                this.getCal().add(r);
                BwResourceContent fromRc = val.getContent();
                BwResourceContent rc = new BwResourceContent();
                rc.setColPath(collTo.getPath());
                rc.setName(val.getName());
                rc.setByteValue(fromRc.getByteValue());
                this.getCal().addContent(val, rc);
                createdNew = true;
            }
            if (!copy) {
                BwCalendar collFrom = this.getCols().get(val.getColPath());
                this.checkAccess((ShareableEntity)collFrom, 14, false);
                this.getCal().delete(val);
                this.getSvc().touchCalendar(val.getColPath());
            }
            this.getSvc().touchCalendar(to);
            return createdNew;
        }
        catch (BedeworkException be) {
            this.getSvc().rollbackTransaction();
            throw be;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            throw new BedeworkException(t);
        }
    }

    public ResourcesI.ReindexCounts reindex(BwIndexer indexer, BwIndexer contentIndexer, BwIndexer collectionIndexer) {
        ResourcesI.ReindexCounts res = new ResourcesI.ReindexCounts();
        Iterator<BwResource> ents = this.isPublicAdmin() ? this.getSvc().getPublicObjectIterator(BwResource.class) : this.getSvc().getPrincipalObjectIterator(BwResource.class);
        TreeSet<String> checkedCollections = new TreeSet<String>();
        CalendarsI cols = this.getSvc().getCalendarsHandler();
        while (ents.hasNext()) {
            BwResource ent = ents.next();
            this.info("Resources: index resource " + ent.getHref());
            String parentPath = ent.getColPath();
            if (ent.getTombstoned()) {
                String token = ent.getEtagValue();
                if (!cols.getSyncTokenIsValid(token, parentPath)) {
                    ++res.skippedTombstonedResources;
                    this.info(String.format("      skipped tombstoned resource %s", ent.getHref()));
                    continue;
                }
            } else {
                try {
                    this.getContent(ent);
                }
                catch (Throwable t) {
                    this.error(t);
                }
            }
            boolean create = true;
            if (!checkedCollections.contains(parentPath)) {
                block14: {
                    try {
                        BwCalendar col = cols.get(parentPath);
                        if (col != null) {
                            create = false;
                            if (this.getSvc().getCalendarsHandler().getIdx(parentPath) == null) {
                                collectionIndexer.indexEntity((Object)col);
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.error(t);
                    }
                    if (create) {
                        this.info("Resources: manufacture parent for resource " + ent.getHref());
                        SplitResult sr = this.splitUri(parentPath);
                        BwCalendar parent = new BwCalendar();
                        parent.setCalType(0);
                        parent.setColPath(sr.path);
                        parent.setPath(parentPath);
                        parent.setName(sr.name);
                        parent.setPublick(ent.getPublick());
                        parent.setOwnerHref(ent.getOwnerHref());
                        parent.setCreatorHref(ent.getCreatorHref());
                        try {
                            BwCalendar newCol = this.getSvc().getCalendarsHandler().add(parent, sr.path);
                            collectionIndexer.indexEntity((Object)newCol);
                        }
                        catch (Throwable t) {
                            if (!this.debug()) break block14;
                            this.error(t);
                        }
                    }
                }
                checkedCollections.add(parentPath);
            }
            indexer.indexEntity((Object)ent);
            ++res.resources;
            if (ent.getContent() == null) continue;
            contentIndexer.indexEntity((Object)ent.getContent());
            ++res.resourceContents;
        }
        return res;
    }

    List<BwResource> getSynchResources(String path, String lastmod) {
        return this.getCal().getResources(path, true, lastmod, -1);
    }

    private boolean save(BwResource val, boolean forNotification, boolean returnIfExists) {
        try {
            BwResource r;
            String path = val.getColPath();
            if (path == null) {
                throw new BedeworkException("No col path for " + val.getName());
            }
            BwCalendar coll = this.getCols().get(path);
            if (coll == null) {
                throw new BedeworkException("org.bedework.exception.calendarnotfound", path);
            }
            if (forNotification) {
                if (coll.getCalType() != 10) {
                    throw new BedeworkException("org.bedework.exception.badrequest", path);
                }
            } else if (this.getSvc().getPrincipalInfo().getSubscriptionsOnly()) {
                throw new BedeworkForbidden("User has read only access");
            }
            if ((r = this.getCal().getResource(val.getHref(), 25)) != null) {
                if (returnIfExists) {
                    return false;
                }
                throw new BedeworkException("org.bedework.exception.duplicate.resource", val.getName());
            }
            BwResourceContent rc = val.getContent();
            if (rc == null) {
                throw new BedeworkException("org.bedework.exception.missing.resource.content");
            }
            this.getSvc().setupSharableEntity((ShareableEntity)val, this.getPrincipal().getPrincipalRef());
            val.setColPath(path);
            if (coll.getCalType() == 1 || coll.getCalType() == 8) {
                throw new BedeworkException("org.bedework.exception.badrequest", path);
            }
            this.checkAccess((ShareableEntity)coll, 9, false);
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().add(val);
            rc.setColPath(val.getColPath());
            rc.setName(val.getName());
            this.getCal().addContent(val, rc);
            this.getSvc().touchCalendar(coll);
            return true;
        }
        catch (BedeworkException be) {
            this.getSvc().rollbackTransaction();
            throw be;
        }
    }

    private SplitResult splitUri(String uri) {
        int pos;
        int end = uri.length();
        if (uri.endsWith("/")) {
            --end;
        }
        if ((pos = uri.lastIndexOf("/", end)) < 0) {
            throw new BedeworkException("Invalid uri: " + uri);
        }
        if (pos == 0) {
            return new SplitResult(uri, null);
        }
        return new SplitResult(uri.substring(0, pos), uri.substring(pos + 1, end));
    }

    private static class SplitResult {
        String path;
        String name;

        SplitResult(String path, String name) {
            this.path = path;
            this.name = name;
        }
    }
}

