/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calsvc.CalSvc;

public class GroupsCallBack
extends Directories.CallBack {
    CalSvc svci;

    GroupsCallBack(CalSvc svci) {
        this.svci = svci;
    }

    public String getSysid() {
        return this.svci.getSystemProperties().getSystemid();
    }

    public BwPrincipal<?> getCurrentUser() {
        return this.svci.getPrincipal();
    }

    public BwGroup<?> findGroup(String account, boolean admin) {
        try {
            return this.svci.getCal().findGroup(account, admin);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Collection<BwGroup<?>> findGroupParents(BwGroup<?> group, boolean admin) {
        try {
            return this.svci.getCal().findGroupParents(group, admin);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void addGroup(BwGroup<?> group, boolean admin) {
        try {
            this.svci.getCal().addGroup(group, admin);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void updateGroup(BwGroup<?> group, boolean admin) {
        try {
            this.svci.getCal().updateGroup(group, admin);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void removeGroup(BwGroup<?> group, boolean admin) {
        this.svci.getCal().removeGroup(group, admin);
    }

    public void addMember(BwGroup<?> group, BwPrincipal<?> val, boolean admin) {
        this.svci.getCal().addMember(group, val, admin);
    }

    public void removeMember(BwGroup<?> group, BwPrincipal<?> val, boolean admin) {
        this.svci.getCal().removeMember(group, val, admin);
    }

    public Collection<BwPrincipal<?>> getMembers(BwGroup<?> group, boolean admin) {
        return this.svci.getCal().getMembers(group, admin);
    }

    public Collection<BwGroup<?>> getAll(boolean admin) {
        return this.svci.getCal().getAllGroups(admin);
    }

    public Collection<BwGroup<?>> getGroups(BwPrincipal<?> val, boolean admin) {
        return this.svci.getCal().getGroups(val, admin);
    }
}

