/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import ietf.params.xml.ns.caldav.FilterType;
import java.util.Collection;
import org.bedework.base.exc.BedeworkAccessException;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.Response;
import org.bedework.caldav.util.filter.parse.EventQuery;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.OwnedEntity;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.FiltersI;
import org.bedework.util.misc.Util;

class Filters
extends CalSvcDb
implements FiltersI {
    Filters(CalSvc svci) {
        super(svci);
    }

    public SimpleFilterParser.ParseResult parse(BwFilterDef val) {
        String def = val.getDefinition();
        if (def.length() > 5 && def.startsWith("<?xml")) {
            SimpleFilterParser.ParseResult pr = new SimpleFilterParser.ParseResult();
            try {
                FilterType f = org.bedework.caldav.util.filter.parse.Filters.parse((String)def);
                EventQuery eq = org.bedework.caldav.util.filter.parse.Filters.getQuery((FilterType)f);
                val.setFilters(eq.filter);
                pr.ok = true;
            }
            catch (Throwable t) {
                pr.ok = false;
                pr.message = t.getMessage();
                pr.be = new BedeworkException(t);
            }
            return pr;
        }
        String source = "BwFilterDef:" + val.getOwnerHref() + ":" + val.getName();
        SimpleFilterParser.ParseResult pr = this.getSvc().getFilterParser().parse(def, false, source);
        if (pr.ok) {
            val.setFilters(pr.filter);
        }
        return pr;
    }

    public void validate(String val) {
        try {
            org.bedework.caldav.util.filter.parse.Filters.parse((String)val);
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    public void add(BwFilterDef val) {
        this.getSvc().setupOwnedEntity((OwnedEntity)val, this.getPrincipal().getPrincipalRef());
        this.validate(val.getDefinition());
        this.getCal().add(val, this.getSvc().getEntityOwner());
    }

    public GetFilterDefResponse get(String name) {
        GetFilterDefResponse gfdr = new GetFilterDefResponse();
        try {
            BwFilterDef fdef = this.getCal().getFilterDef(name, this.getSvc().getEntityOwner());
            if (fdef == null) {
                gfdr.setStatus(Response.Status.notFound);
            } else {
                gfdr.setStatus(Response.Status.ok);
                gfdr.setFilterDef(fdef);
            }
        }
        catch (BedeworkException be) {
            gfdr.setStatus(Response.Status.failed);
            gfdr.setMessage(be.getLocalizedMessage());
        }
        return gfdr;
    }

    public Collection<BwFilterDef> getAll() {
        BwPrincipal<?> owner = this.getSvc().getEntityOwner();
        return this.getCal().getAllFilterDefs(owner);
    }

    public void update(BwFilterDef val) {
        if (!this.getSvc().getSuperUser() && !this.getPrincipal().getPrincipalRef().equals(val.getOwnerHref())) {
            throw new BedeworkAccessException();
        }
        this.getCal().update(val);
    }

    public void delete(String name) {
        this.getCal().deleteFilterDef(name, this.getSvc().getEntityOwner());
    }

    public SimpleFilterParser.ParseResult parseSort(String val) {
        return this.getSvc().getFilterParser().parseSort(val);
    }

    public int reindex(BwIndexer indexer) {
        Collection<BwFilterDef> filters = this.getAll();
        if (Util.isEmpty(filters)) {
            return 0;
        }
        for (BwFilterDef f : filters) {
            indexer.indexEntity((Object)f);
        }
        return filters.size();
    }
}

