/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.EventPropertiesImpl;
import org.bedework.calsvci.Categories;
import org.bedework.util.calendar.PropertyIndex;

public class CategoriesImpl
extends EventPropertiesImpl<BwCategory>
implements Categories {
    public CategoriesImpl(CalSvc svci) {
        super(svci);
    }

    public void init(boolean adminCanEditAllPublic) {
        super.init(BwCategory.class.getCanonicalName(), adminCanEditAllPublic);
    }

    @Override
    String getDocType() {
        return "category";
    }

    @Override
    Collection<BwCategory> fetchAllIndexed(boolean publick, String ownerHref) {
        return this.filterDeleted(this.getIndexer(publick, ownerHref).fetchAllCats());
    }

    @Override
    BwCategory fetchIndexedByUid(String uid) {
        return this.getIndexer().fetchCat(uid, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.UID});
    }

    @Override
    BwCategory fetchIndexed(String href) {
        return this.getIndexer().fetchCat(href, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.HREF});
    }

    @Override
    GetEntityResponse<BwCategory> findPersistent(BwCategory val, String ownerHref) {
        return this.findPersistent(val.getWord(), ownerHref);
    }

    @Override
    public boolean exists(Response resp, BwCategory cat) {
        GetEntityResponse getResp = this.findPersistent(cat.getWord(), cat.getOwnerHref());
        if (getResp.isError()) {
            Response.fromResponse((Response)resp, getResp);
            return false;
        }
        return getResp.isOk();
    }

    public BwCategory find(BwString val) {
        return this.getIndexer().fetchCat(val.getValue(), new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.CATEGORIES, PropertyIndex.PropertyInfoIndex.VALUE});
    }

    public GetEntitiesResponse<BwCategory> find(String fexpr, int from, int size) {
        SimpleFilterParser.ParseResult pr = this.getSvc().getFilterParser().parse(fexpr, false, null);
        if (!pr.ok) {
            return (GetEntitiesResponse)Response.error((Response)new GetEntitiesResponse(), (String)pr.message);
        }
        return this.getIndexer().findCategories(pr.filter, from, size);
    }
}

