/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.UUID;
import org.bedework.access.CurrentAccess;
import org.bedework.calcorei.Calintf;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.CalSvcIPars;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.UsersI;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class CalSvcDb
implements Logged,
Serializable {
    private CalSvc svci;
    private CalSvcIPars pars;
    private final BwLogger logger = new BwLogger();

    public CalSvcDb(CalSvc svci) {
        this.setSvc(svci);
    }

    public void open() {
    }

    public void close() {
    }

    public static String getEncodedUuid() {
        return Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
    }

    protected Timestamp getCurrentTimestamp() {
        return this.getSvc().getCurrentTimestamp();
    }

    protected BwPrincipal caladdrToPrincipal(String href) {
        return this.getSvc().getDirectories().caladdrToPrincipal(href);
    }

    protected CalSvcIPars getPars() {
        return this.pars;
    }

    protected boolean isSuper() {
        return this.pars.getPublicAdmin() && this.svci.getSuperUser();
    }

    protected boolean isGuest() {
        return this.pars.isGuest();
    }

    protected boolean isPublicAdmin() {
        return this.pars.getPublicAdmin();
    }

    protected BwPrincipal getPrincipal() {
        return this.svci.getPrincipal();
    }

    protected String getPrincipalHref() {
        return this.svci.getPrincipal().getPrincipalRef();
    }

    public BwIndexer getIndexer(String docType) {
        return this.svci.getIndexer(docType);
    }

    protected BwPrincipal getPrincipal(String href) {
        return this.svci.getUsersHandler().getPrincipal(href);
    }

    public void setSvc(CalSvcI svci) {
        this.svci = (CalSvc)svci;
        if (svci != null) {
            this.pars = this.svci.getPars();
        }
    }

    protected CalSvc getSvc() {
        return this.svci;
    }

    protected CalendarsI getCols() {
        return this.svci.getCalendarsHandler();
    }

    protected NotificationsI getNotes() {
        return this.svci.getNotificationsHandler();
    }

    protected ResourcesI getRess() {
        return this.svci.getResourcesHandler();
    }

    protected BwPreferences getPrefs() {
        return this.svci.getPrefsHandler().get();
    }

    protected BwPreferences getPrefs(BwPrincipal principal) {
        return this.svci.getPrefsHandler().get(principal);
    }

    protected UsersI getUsers() {
        return this.svci.getUsersHandler();
    }

    protected Calintf getCal() {
        try {
            return this.svci.getCal();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Calintf getCal(BwCalendar cal) {
        return this.svci.getCal(cal);
    }

    protected BwPrincipal<?> getPublicUser() {
        return this.getSvc().getUsersHandler().getPublicUser();
    }

    protected CurrentAccess checkAccess(ShareableEntity ent, int desiredAccess, boolean returnResult) {
        return this.svci.checkAccess(ent, desiredAccess, returnResult);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

