/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.importer;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format;
import org.beangle.data.transfer.importer.AttributePrepare;
import org.beangle.data.transfer.importer.ImportListener;
import org.beangle.data.transfer.importer.ImportPrepare;
import org.beangle.data.transfer.importer.ImportResult;
import org.beangle.data.transfer.importer.Importer;
import org.beangle.data.transfer.io.Attribute;
import org.beangle.data.transfer.io.Reader;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public abstract class AbstractImporter
implements Importer,
Logging {
    private Reader reader;
    private Attribute[] attrs;
    private Map curData;
    private ImportPrepare prepare;
    private boolean stopOnError;
    private Logger logger;
    private ImportResult transferResult;
    private final ListBuffer listeners;
    private int success;
    private int fail;
    private int index;

    public AbstractImporter() {
        Importer.$init$(this);
        Logging.$init$((Logging)this);
        this.listeners = new ListBuffer();
        this.success = 0;
        this.fail = 0;
        this.prepare_$eq(new AttributePrepare());
        this.index = 0;
        Statics.releaseFence();
    }

    @Override
    public Reader reader() {
        return this.reader;
    }

    @Override
    public Attribute[] attrs() {
        return this.attrs;
    }

    public Map curData() {
        return this.curData;
    }

    @Override
    public ImportPrepare prepare() {
        return this.prepare;
    }

    @Override
    public boolean stopOnError() {
        return this.stopOnError;
    }

    @Override
    public void reader_$eq(Reader x$1) {
        this.reader = x$1;
    }

    @Override
    public void attrs_$eq(Attribute[] x$1) {
        this.attrs = x$1;
    }

    public void curData_$eq(Map x$1) {
        this.curData = x$1;
    }

    @Override
    public void prepare_$eq(ImportPrepare x$1) {
        this.prepare = x$1;
    }

    @Override
    public void stopOnError_$eq(boolean x$1) {
        this.stopOnError = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public ImportResult transferResult() {
        return this.transferResult;
    }

    public void transferResult_$eq(ImportResult x$1) {
        this.transferResult = x$1;
    }

    public ListBuffer<ImportListener> listeners() {
        return this.listeners;
    }

    @Override
    public int success() {
        return this.success;
    }

    public void success_$eq(int x$1) {
        this.success = x$1;
    }

    @Override
    public int fail() {
        return this.fail;
    }

    public void fail_$eq(int x$1) {
        this.fail = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    @Override
    public void transfer(ImportResult tr) {
        this.transferResult_$eq(tr);
        this.transferResult().transfer_$eq(this);
        long transferStartAt = System.currentTimeMillis();
        try {
            this.prepare().prepare(this);
            this.listeners().foreach((Function1)(JProcedure1 & Serializable)l -> l.onStart(tr));
            boolean stopped = false;
            while (!stopped && this.read()) {
                this.index_$eq(this.index() + 1);
                try {
                    this.beforeImportItem();
                    if (!this.isDataValid()) continue;
                    int errors = tr.errors();
                    this.listeners().foreach((Function1)(JProcedure1 & Serializable)l -> l.onItemStart(tr));
                    if (tr.errors() != errors) continue;
                    this.transferItem();
                    this.listeners().foreach((Function1)(JProcedure1 & Serializable)l -> l.onItemFinish(tr));
                    if (tr.errors() == errors) {
                        this.success_$eq(this.success() + 1);
                        continue;
                    }
                    this.fail_$eq(this.fail() + 1);
                }
                catch (Throwable e) {
                    Logger$.MODULE$.error$extension(this.logger(), () -> AbstractImporter.transfer$$anonfun$4(e), () -> AbstractImporter.transfer$$anonfun$5(e));
                    if (this.stopOnError()) {
                        stopped = true;
                        tr.addFailure("\u5bfc\u5165\u5f02\u5e38,\u5269\u4f59\u6570\u636e\u505c\u6b62\u5bfc\u5165", e.getMessage());
                    } else {
                        tr.addFailure("\u5bfc\u5165\u5f02\u5e38", e.getMessage());
                    }
                    this.fail_$eq(this.fail() + 1);
                }
            }
            this.listeners().foreach((Function1)(JProcedure1 & Serializable)l -> l.onFinish(tr));
            this.reader().close();
        }
        catch (Throwable e) {
            tr.addFailure("\u5bfc\u5165\u5f02\u5e38", e.getMessage());
        }
        Logger$.MODULE$.debug$extension(this.logger(), () -> AbstractImporter.transfer$$anonfun$7(transferStartAt));
    }

    @Override
    public boolean ignoreNull() {
        return true;
    }

    @Override
    public Locale locale() {
        return Locale.getDefault();
    }

    @Override
    public Format format() {
        return this.reader().format();
    }

    @Override
    public int transferIndex() {
        return this.index();
    }

    @Override
    public String dataLocation() {
        return this.reader() != null ? this.reader().location() : "-1";
    }

    @Override
    public Importer addListener(ImportListener listener) {
        this.listeners().$plus$eq((Object)listener);
        listener.transfer_$eq(this);
        return this;
    }

    public void beforeImportItem() {
    }

    public void changeCurValue(String attr, Object value) {
        this.curData().put((Object)attr, value);
    }

    @Override
    public final boolean read() {
        boolean bl;
        Object data = this.reader().read();
        if (data == null) {
            this.current_$eq(null);
            this.curData_$eq((Map)null);
            bl = false;
        } else {
            this.curData_$eq((Map)new HashMap());
            Object object = Predef$.MODULE$.genericArrayOps(data);
            ArrayOps$.MODULE$.indices$extension(object).foreach((Function1 & Serializable)i -> this.read$$anonfun$1(data, BoxesRunTime.unboxToInt((Object)i)));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isDataValid() {
        return this.curData().values().exists((Function1 & Serializable)v -> {
            boolean bl;
            Object object = v;
            if (object instanceof String) {
                String tt = (String)object;
                bl = Strings$.MODULE$.isNotBlank((CharSequence)tt);
            } else {
                bl = v != null;
            }
            return bl;
        });
    }

    public void setAttrs(List<Attribute> attrs) {
        this.attrs_$eq((Attribute[])attrs.toArray(ClassTag$.MODULE$.apply(Attribute.class)));
    }

    private static final String transfer$$anonfun$4(Throwable e$1) {
        return e$1.getMessage();
    }

    private static final Throwable transfer$$anonfun$5(Throwable e$2) {
        return e$2;
    }

    private static final String transfer$$anonfun$7(long transferStartAt$1) {
        return "importer elapse: " + (System.currentTimeMillis() - transferStartAt$1);
    }

    private final /* synthetic */ Option read$$anonfun$1(Object data$1, int i) {
        return this.curData().put((Object)this.attrs()[i].name(), ScalaRunTime$.MODULE$.array_apply(data$1, i));
    }
}

