/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.importer;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.Domain;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.model.util.Populator;
import org.beangle.data.transfer.IllegalFormatException;
import org.beangle.data.transfer.importer.AbstractImporter;
import org.beangle.data.transfer.importer.EntityImporter;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.mutable.HashMap;
import scala.runtime.function.JProcedure1;

public class MultiEntityImporter
extends AbstractImporter
implements EntityImporter {
    private Populator populator;
    private Domain domain;
    private HashMap currents;
    private final HashMap entityTypes;

    public MultiEntityImporter() {
        EntityImporter.$init$(this);
        this.currents = new HashMap();
        this.entityTypes = new HashMap();
    }

    @Override
    public Populator populator() {
        return this.populator;
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    @Override
    public void populator_$eq(Populator x$1) {
        this.populator = x$1;
    }

    @Override
    public void domain_$eq(Domain x$1) {
        this.domain = x$1;
    }

    public HashMap<String, Object> currents() {
        return this.currents;
    }

    public void currents_$eq(HashMap<String, Object> x$1) {
        this.currents = x$1;
    }

    public HashMap<String, EntityType> entityTypes() {
        return this.entityTypes;
    }

    public Iterable<String> aliases() {
        return this.entityTypes().keys();
    }

    private scala.collection.mutable.Map<String, Object> sub(Map<String, Object> data, String alias) {
        String prefix = alias + ".";
        HashMap newParams = new HashMap();
        data.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (key.indexOf(prefix) == 0) {
                    newParams.put((Object)key.substring(prefix.length()), value);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return newParams;
    }

    @Override
    public void transferItem() {
        this.entityTypes().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            EntityType etype = (EntityType)tuple2._2();
            Object entity = this.getCurrent(name);
            this.sub((Map<String, Object>)this.curData(), name).foreach((Function1)(JProcedure1 & Serializable)entry -> {
                Object value = entry._2();
                Object object = value;
                if (object instanceof String) {
                    String s = (String)object;
                    value = Strings$.MODULE$.isBlank((CharSequence)s) ? null : Strings$.MODULE$.trim(s);
                }
                if (value != null) {
                    if (value.equals("null")) {
                        value = null;
                    }
                    this.populateValue((Entity)entity, etype, (String)entry._1(), value);
                }
            });
        });
    }

    public void populateValue(Entity<?> entity, EntityType etype, String attr, Object value) {
        if (Strings$.MODULE$.contains((CharSequence)attr, 46)) {
            Entity e;
            String parentPath = Strings$.MODULE$.substringBeforeLast(attr, ".");
            Tuple2 propertyType = this.populator().init(entity, etype, parentPath);
            Object property = propertyType._1();
            Object object = property;
            if (object instanceof Entity && (e = (Entity)object).persisted()) {
                this.populator().populate(entity, etype, parentPath, null);
                this.populator().init(entity, etype, parentPath);
            }
        }
        if (!this.populator().populate(entity, etype, attr, value)) {
            this.transferResult().addFailure(this.description(attr) + " data format error.", value);
        }
    }

    public Class<?> getEntityClass(String alias) {
        return this.getEntityType(alias).clazz();
    }

    public EntityType getEntityType(String alias) {
        return (EntityType)this.entityTypes().apply((Object)alias);
    }

    public void addEntity(Class<?> clazz) {
        String shortName = Strings$.MODULE$.uncapitalize(Strings$.MODULE$.substringAfterLast(clazz.getName(), "."));
        this.addEntity(shortName, clazz);
    }

    public void addEntity(String alias, Class<?> entityClass) {
        Option option = this.domain().getEntity(entityClass);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("cannot find entity type for " + entityClass);
            }
            throw new MatchError((Object)option);
        }
        EntityType entityType = (EntityType)((Some)option).value();
        this.entityTypes().put((Object)alias, (Object)entityType);
    }

    public void addEntity(String alias, String entityName) {
        Option option = this.domain().getEntity(entityName);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("cannot find entity type for " + entityName);
            }
            throw new MatchError((Object)option);
        }
        EntityType entityType = (EntityType)((Some)option).value();
        this.entityTypes().put((Object)alias, (Object)entityType);
    }

    public String getEntityName(String attr) {
        return this.getEntityType(attr).entityName();
    }

    /*
     * WARNING - void declaration
     */
    public Object getCurrent(String alias) {
        void var2_2;
        Object entity = this.currents().get((Object)alias).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (entity == null) {
            Option option = this.entityTypes().get((Object)alias);
            if (option instanceof Some) {
                EntityType entityType = (EntityType)((Some)option).value();
                entity = entityType.newInstance();
                this.currents().put((Object)alias, entity);
            } else {
                if (None$.MODULE$.equals(option)) {
                    Logger$.MODULE$.error$extension(this.logger(), MultiEntityImporter::getCurrent$$anonfun$1);
                    throw new IllegalFormatException("Not register entity type for " + alias, null);
                }
                throw new MatchError((Object)option);
            }
        }
        return var2_2;
    }

    @Override
    public String dataName() {
        return "multi entity";
    }

    @Override
    public void current_$eq(Object obj) {
        this.currents_$eq((HashMap<String, Object>)((HashMap)obj));
    }

    @Override
    public Object current() {
        return this.currents();
    }

    @Override
    public void beforeImportItem() {
        this.currents().clear();
    }

    private static final String getCurrent$$anonfun$1() {
        return "Not register entity type for $alias";
    }
}

