/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.api.style;

import java.util.Objects;
import javax.annotation.Nonnull;

public class TreeStyle {
    private final String junction;
    private final String indent;
    private final String blankIndent;
    private final String lastJunction;
    private final String calloutStart;
    private final String calloutEnd;

    public TreeStyle(String pJunction, String pIndent, String pLastJunction, String pCalloutStart, String pCalloutEnd) {
        this.junction = Objects.requireNonNull(pJunction, "Argument pJunction must not be null");
        this.indent = Objects.requireNonNull(pIndent, "Argument pIndent must not be null");
        this.blankIndent = this.generateBlankIndent(pIndent);
        this.lastJunction = Objects.requireNonNull(pLastJunction, "Argument pLastJunction must not be null");
        this.calloutStart = Objects.requireNonNull(pCalloutStart, "Argument pCalloutStart must not be null");
        this.calloutEnd = Objects.requireNonNull(pCalloutEnd, "Argument pCalloutEnd must not be null");
        if (pIndent.length() != pJunction.length() || pIndent.length() != pLastJunction.length()) {
            throw new IllegalArgumentException("element size mismatch");
        }
    }

    @Nonnull
    private String generateBlankIndent(@Nonnull String pIndent) {
        return pIndent.replaceAll(".", " ");
    }

    @Nonnull
    public String getIndent() {
        return this.indent;
    }

    @Nonnull
    public String getBlankIndent() {
        return this.blankIndent;
    }

    @Nonnull
    public String getJunction() {
        return this.junction;
    }

    @Nonnull
    public String getLastJunction() {
        return this.lastJunction;
    }

    @Nonnull
    public String getCalloutStart() {
        return this.calloutStart;
    }

    @Nonnull
    public String getCalloutEnd() {
        return this.calloutEnd;
    }
}

