/*
 * Decompiled with CFR 0.152.
 */
package ti2-2-0.org.barfuin.texttree.internal;

import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import ti2-2-0.org.barfuin.texttree.api.Node;
import ti2-2-0.org.barfuin.texttree.api.TextTree;
import ti2-2-0.org.barfuin.texttree.api.TreeOptions;
import ti2-2-0.org.barfuin.texttree.api.color.NodeColor;
import ti2-2-0.org.barfuin.texttree.api.style.AnnotationPosition;
import ti2-2-0.org.barfuin.texttree.api.style.TreeStyle;
import ti2-2-0.org.barfuin.texttree.internal.CalloutInternal;
import ti2-2-0.org.barfuin.texttree.internal.ColorizableAppender;
import ti2-2-0.org.barfuin.texttree.internal.CycleDetector;
import ti2-2-0.org.barfuin.texttree.internal.TreeElementType;
import ti2-2-0.org.barfuin.texttree.internal.TreeUtil;

@NotThreadSafe
public class TextTreeImpl
implements TextTree {
    private static final String SPACES = "                                                                                                                                                                                   ";
    private final TreeOptions options;
    private ColorizableAppender appender = null;
    private CycleDetector cycleDetector = null;
    private int treeWidth = -1;

    public TextTreeImpl() {
        this(null);
    }

    public TextTreeImpl(@Nullable TreeOptions pOptions) {
        this.options = pOptions != null ? pOptions : new TreeOptions();
    }

    @Override
    @Nonnull
    public String render(@Nullable Node pNode) {
        this.init(pNode);
        if (pNode != null) {
            this.render("", 0, pNode, false);
        } else {
            this.appender.appendText(null, null);
        }
        return this.appender.finishUp();
    }

    private void init(@Nullable Node pNode) {
        this.appender = new ColorizableAppender(this.options);
        this.cycleDetector = new CycleDetector(this.options);
        if (this.options.getAnnotationPosition() == AnnotationPosition.Aligned) {
            this.treeWidth = this.precalcTreeWidth(pNode);
        }
    }

    private void render(@Nonnull String pPrefix, int pLevel, @Nullable Node pNode, boolean pPrecalcWidth) {
        TreeStyle style = this.options.getStyle();
        int nodeTextLastLineLen = this.printNodeText(pPrefix, pNode);
        CalloutInternal callout = this.cycleDetector.visit(pNode);
        if (callout != CalloutInternal.None) {
            this.printCallout(callout, pNode, pPrecalcWidth);
            this.cycleDetector.pop();
            return;
        }
        if (this.options.getAnnotationPosition().isStartsOnNewLine() || pNode == null || pNode.getAnnotation() == null) {
            this.appender.newLine();
        }
        boolean hasChildren = TextTreeImpl.hasChildren(pNode);
        if (pNode != null) {
            this.printAnnotation(pPrefix, nodeTextLastLineLen, pNode, hasChildren);
            this.printVerticalSpacing(pPrefix, hasChildren);
            if (hasChildren) {
                Iterator<? extends Node> iter = pNode.getChildren().iterator();
                while (iter.hasNext()) {
                    boolean maxDepthExceeded = this.options.getMaxDepth() > 0 && pLevel >= this.options.getMaxDepth();
                    Node child = iter.next();
                    this.appender.append(TreeElementType.Edge, pPrefix);
                    this.appender.append(TreeElementType.Edge, iter.hasNext() && !maxDepthExceeded ? style.getJunction() : style.getLastJunction());
                    if (maxDepthExceeded) {
                        this.printCallout(CalloutInternal.MaxDepth, child, pPrecalcWidth);
                        break;
                    }
                    this.render(pPrefix + (iter.hasNext() ? style.getIndent() : style.getBlankIndent()), pLevel + 1, child, pPrecalcWidth);
                }
            }
        } else {
            this.printVerticalSpacing(pPrefix, hasChildren);
        }
        this.cycleDetector.pop();
    }

    private void printVerticalSpacing(@Nonnull String pPrefix, boolean pHasChildren) {
        String prefix = pPrefix + (pHasChildren ? this.options.getStyle().getIndent() : "");
        String trimmed = TreeUtil.rtrim(prefix);
        if (!trimmed.isEmpty()) {
            for (int i = 0; i < this.options.getVerticalSpacing(); ++i) {
                this.appender.append(TreeElementType.Edge, trimmed);
                this.appender.newLine();
            }
        }
    }

    private int printNodeText(@Nonnull String pPrefix, @Nullable Node pNode) {
        String text;
        int lastLineLength = 0;
        String string = text = pNode != null ? pNode.getText() : null;
        if (text != null) {
            String[] lines = text.split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                lastLineLength = TreeUtil.lengthWithoutEsc(line);
                if (i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                this.appender.appendText(line, pNode.getColor());
                if (i >= lines.length - 1) continue;
                this.appender.newLine();
            }
        } else {
            this.appender.appendText(null, pNode != null ? pNode.getColor() : null);
            lastLineLength = "null".length();
        }
        return lastLineLength;
    }

    private void printCallout(@Nonnull CalloutInternal pCallout, @Nullable Node pNode, boolean pPrecalcWidth) {
        boolean printCallout = !pPrecalcWidth;
        String calloutText = null;
        if (printCallout && this.options.getCalloutProcessor() != null && (calloutText = this.options.getCalloutProcessor().apply(pCallout.getApiCallout(), pNode)) == null) {
            printCallout = false;
        }
        if (printCallout) {
            if (calloutText == null) {
                calloutText = this.options.getCalloutText(pCallout.getApiCallout());
            }
            if (calloutText == null) {
                calloutText = pCallout.getText();
            }
            if (pCallout.isPrintOnSameLine()) {
                this.appender.appendText(" ", null);
            }
            TreeStyle style = this.options.getStyle();
            this.appender.append(pCallout.getElementType(), style.getCalloutStart());
            this.appender.append(pCallout.getElementType(), calloutText);
            this.appender.append(pCallout.getElementType(), style.getCalloutEnd());
        }
        this.appender.newLine();
    }

    private void printAnnotation(@Nonnull String pPrefix, int pNodeTextLastLineLen, @Nonnull Node pNode, boolean pHasChildren) {
        String annotation = pNode.getAnnotation();
        NodeColor colorOverride = pNode.getAnnotationColor();
        TreeStyle style = this.options.getStyle();
        if (annotation != null && !annotation.isEmpty() && this.options.getAnnotationPosition() != AnnotationPosition.None) {
            String[] lines = annotation.trim().split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                int numSpaces;
                String line = lines[i];
                if (this.options.getAnnotationPosition().isStartsOnNewLine() || i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                if (this.options.getAnnotationPosition() == AnnotationPosition.Inline) {
                    if (i > 0) {
                        this.appender.append(TreeElementType.Annotation, "  ", colorOverride);
                    } else {
                        this.appender.append(TreeElementType.Text, " ");
                    }
                } else if (this.options.getAnnotationPosition() == AnnotationPosition.InlineRight) {
                    if (i > 0) {
                        this.appender.append(TreeElementType.Edge, pHasChildren ? style.getIndent() : style.getBlankIndent());
                        numSpaces = Math.max(0, pNodeTextLastLineLen - style.getBlankIndent().length() + 1);
                        this.appender.append(TreeElementType.Annotation, this.nSpaces(numSpaces));
                    } else {
                        numSpaces = Math.max(1, style.getBlankIndent().length() - pNodeTextLastLineLen);
                        this.appender.append(TreeElementType.Text, this.nSpaces(numSpaces));
                    }
                } else if (this.options.getAnnotationPosition() == AnnotationPosition.Aligned) {
                    numSpaces = Math.max(1, this.treeWidth - this.appender.getCurrentLineLength() + 1);
                    if (i > 0 && pHasChildren) {
                        this.appender.append(TreeElementType.Edge, style.getIndent());
                        numSpaces -= style.getIndent().length();
                    }
                    this.appender.append(TreeElementType.Annotation, this.nSpaces(numSpaces), colorOverride);
                } else if (this.options.getAnnotationPosition() == AnnotationPosition.Indented) {
                    this.appender.append(TreeElementType.Edge, pHasChildren ? style.getIndentTrimmed() : style.getBlankIndentTrimmed());
                    this.appender.append(TreeElementType.Annotation, " ", colorOverride);
                }
                this.appender.append(TreeElementType.Annotation, line, colorOverride);
                this.appender.newLine();
            }
        }
    }

    static boolean hasChildren(@Nullable Node pNode) {
        boolean result = false;
        if (pNode != null && pNode.getChildren() != null) {
            Iterator<? extends Node> iter = pNode.getChildren().iterator();
            return iter != null && iter.hasNext();
        }
        return result;
    }

    private int precalcTreeWidth(@Nullable Node pNode) {
        TreeOptions noAnnotations = TreeOptions.copyOf(this.options);
        noAnnotations.setAnnotationPosition(AnnotationPosition.None);
        noAnnotations.setColorScheme(null);
        TextTreeImpl textTree = new TextTreeImpl(noAnnotations);
        textTree.init(pNode);
        textTree.render("", 0, pNode, true);
        String bareTree = textTree.appender.finishUp();
        return this.longestLine(bareTree);
    }

    int longestLine(@Nonnull String pMultilineString) {
        boolean containsEscapes = TreeUtil.containsEscapes(pMultilineString);
        int result = -1;
        int startOfLine = 0;
        int nlPos = pMultilineString.indexOf(System.lineSeparator());
        while (nlPos >= 0) {
            int lineLength = nlPos - startOfLine;
            if (containsEscapes) {
                lineLength = TreeUtil.lengthWithoutEsc(pMultilineString.substring(startOfLine, nlPos));
            }
            if (lineLength > result) {
                result = lineLength;
            }
            startOfLine = nlPos + System.lineSeparator().length();
            nlPos = pMultilineString.indexOf(System.lineSeparator(), startOfLine);
        }
        int lineLength = pMultilineString.length() - startOfLine;
        if (lineLength > result) {
            result = lineLength;
        }
        return result;
    }

    String nSpaces(int pNumSpaces) {
        if (pNumSpaces <= SPACES.length()) {
            return SPACES.substring(0, pNumSpaces);
        }
        return Stream.generate(() -> " ").limit(pNumSpaces).collect(Collectors.joining());
    }
}

