/*
 * Decompiled with CFR 0.152.
 */
package ti2-2-0.org.barfuin.texttree.api.style;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ti2-2-0.org.barfuin.texttree.internal.TreeUtil;

public class TreeStyle {
    private final String junction;
    private final String indent;
    private final String blankIndent;
    private final String indentTrimmed;
    private final String blankIndentTrimmed;
    private final String lastJunction;
    private final String calloutStart;
    private final String calloutEnd;

    public TreeStyle(String pJunction, String pIndent, String pLastJunction, String pCalloutStart, String pCalloutEnd) {
        this.junction = this.requireNonEmpty(pJunction, "Argument pJunction must not be null or empty");
        this.indent = this.requireNonEmpty(pIndent, "Argument pIndent must not be null or empty");
        this.blankIndent = this.generateBlankIndent(pIndent);
        this.indentTrimmed = TreeUtil.rtrim(pIndent);
        this.blankIndentTrimmed = this.generateBlankIndent(this.indentTrimmed);
        this.lastJunction = this.requireNonEmpty(pLastJunction, "Argument pLastJunction must not be null or empty");
        this.calloutStart = Objects.requireNonNull(pCalloutStart, "Argument pCalloutStart must not be null");
        this.calloutEnd = Objects.requireNonNull(pCalloutEnd, "Argument pCalloutEnd must not be null");
        if (pJunction.length() != pLastJunction.length()) {
            throw new IllegalArgumentException("element size mismatch");
        }
    }

    public TreeStyle(String pJunction, String pIndent, String pLastJunction) {
        this(pJunction, pIndent, pLastJunction, "<", ">");
    }

    private String requireNonEmpty(@Nullable String pString, @Nonnull String pMessage) {
        String result = Objects.requireNonNull(pString, pMessage);
        if (result.isEmpty()) {
            throw new IllegalArgumentException(pMessage);
        }
        return result;
    }

    @Nonnull
    private String generateBlankIndent(@Nonnull String pIndent) {
        return pIndent.replaceAll(".", " ");
    }

    @Nonnull
    public String getIndent() {
        return this.indent;
    }

    @Nonnull
    public String getBlankIndent() {
        return this.blankIndent;
    }

    @Nonnull
    public String getIndentTrimmed() {
        return this.indentTrimmed;
    }

    @Nonnull
    public String getBlankIndentTrimmed() {
        return this.blankIndentTrimmed;
    }

    @Nonnull
    public String getJunction() {
        return this.junction;
    }

    @Nonnull
    public String getLastJunction() {
        return this.lastJunction;
    }

    @Nonnull
    public String getCalloutStart() {
        return this.calloutStart;
    }

    @Nonnull
    public String getCalloutEnd() {
        return this.calloutEnd;
    }
}

