/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.util.GradleVersion;
import ti2-2-0.org.apache.commons.lang3.reflect.FieldUtils;
import ti2-2-0.org.apache.commons.lang3.reflect.MethodUtils;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    @Nonnull
    public static Object readField(@Nonnull Object pObject, String pDescription, @Nonnull List<String> pFieldNames) {
        return Objects.requireNonNull(ReflectUtil.readField(pObject, pDescription, pFieldNames, false));
    }

    @CheckForNull
    public static Object readField(@Nonnull Object pObject, String pDescription, @Nonnull List<String> pFieldNames, boolean pAllowNull) {
        String objType = pObject.getClass().getName();
        for (String fieldName : pFieldNames) {
            try {
                Object result = FieldUtils.readField(pObject, fieldName, true);
                if (result != null) {
                    return result;
                }
                if (!pAllowNull) continue;
                return null;
            }
            catch (IllegalArgumentException result) {
            }
            catch (IllegalAccessException | RuntimeException e) {
                ReflectUtil.throwGradleException(pDescription, objType, e);
            }
        }
        if (!pAllowNull) {
            ReflectUtil.throwGradleException(pDescription, objType, null);
        }
        return null;
    }

    public static boolean hasField(Object pObject, String pFieldName) {
        try {
            return FieldUtils.getField(pObject.getClass(), pFieldName, true) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Nonnull
    public static Object getExecutionPlan(@Nonnull TaskExecutionGraph pTaskGraph) {
        Object epResult = ReflectUtil.readField(pTaskGraph, "task execution plan", Arrays.asList("taskExecutionPlan", "executionPlan"));
        if (ReflectUtil.isInstanceOf("org.gradle.execution.plan.FinalizedExecutionPlan", epResult) && (epResult = ReflectUtil.callMethodIfPresent(epResult, "getContents", new Object[0])) == null) {
            ReflectUtil.throwGradleException("execution plan contents", "org.gradle.execution.plan.FinalizedExecutionPlan", null);
        }
        return epResult;
    }

    @CheckForNull
    public static Object callMethodIfPresent(@Nullable Object pObject, @Nonnull String pMethodName, Object ... pParameters) {
        Object result = null;
        if (pObject != null) {
            try {
                Method method;
                Class[] paramTypes = null;
                if (pParameters != null) {
                    paramTypes = (Class[])((Stream)Arrays.stream(pParameters).sequential()).map(Object::getClass).toArray(Class[]::new);
                }
                if ((method = MethodUtils.getAccessibleMethod(pObject.getClass(), pMethodName, paramTypes)) != null) {
                    result = method.invoke(pObject, pParameters);
                }
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return result;
    }

    @CheckForNull
    public static Class<?> loadClassIfPossible(@Nonnull String pFqcn) {
        Class<?> result = null;
        try {
            result = Class.forName(pFqcn);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isInstanceOf(@Nonnull String pSuperFqcn, @Nullable Object pObject) {
        Class<?> superClass;
        boolean result = false;
        if (pObject != null && (superClass = ReflectUtil.loadClassIfPossible(pSuperFqcn)) != null) {
            result = superClass.isAssignableFrom(pObject.getClass());
        }
        return result;
    }

    private static void throwGradleException(String pDescription, String pType, Throwable pCause) {
        throw new GradleException("Failed to access " + pDescription + " in Gradle on object of type '" + pType + "'. When this happens, it normally means you are using a new version of Gradle which is not supported by this plugin yet. You are using " + GradleVersion.current().toString() + ". Open an issue at https://gitlab.com/barfuin/gradle-taskinfo/-/issues.", pCause);
    }
}

