/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.util;

import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.util.GradleVersion;

public final class GradleVersionUtil {
    private static final GradleVersion GRADLE_34 = GradleVersion.version((String)"3.4");
    private static final GradleVersion GRADLE_49_RC_1 = GradleVersion.version((String)"4.9-rc-1");
    private static final GradleVersion GRADLE_76 = GradleVersion.version((String)"7.6");

    private GradleVersionUtil() {
    }

    public static boolean isMinimumSupportedVersion() {
        return GradleVersion.current().compareTo(GRADLE_34) >= 0;
    }

    public static String getMinimumSupportedVersion() {
        return GRADLE_34.getVersion();
    }

    public static void validateMinimumGradleVersion(String pTaskName) {
        if (!GradleVersionUtil.isMinimumSupportedVersion()) {
            throw new UnsupportedVersionException("The '" + pTaskName + "' task defined by the '" + "org.barfuin.gradle.taskinfo" + "' plugin requires at least Gradle " + GradleVersionUtil.getMinimumSupportedVersion() + " to be run.");
        }
    }

    public static boolean isDeferredConfigSupported() {
        return GradleVersion.current().compareTo(GRADLE_49_RC_1) >= 0;
    }

    public static String getDeferredConfigMinVersion() {
        return GRADLE_49_RC_1.getVersion();
    }

    public static boolean isOnlyPartiallySupported() {
        return GradleVersion.current().compareTo(GRADLE_76) >= 0;
    }
}

