/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.gradle.api.tasks.TaskAction;
import ti2-2-0.org.barfuin.texttree.api.CycleProtection;
import ti2-2-0.org.barfuin.texttree.api.IdentityScheme;
import ti2-2-0.org.barfuin.texttree.api.TextTree;
import ti2-2-0.org.barfuin.texttree.api.TreeOptions;
import ti2-2-0.org.barfuin.texttree.api.style.AnnotationPosition;

public class TaskInfoTreeTask
extends AbstractInfoTask {
    public TaskInfoTreeTask() {
        this.setDescription("Displays task dependencies of a given task as a tree, and their task types.");
    }

    @Override
    @TaskAction
    public void executeTaskInfo() {
        this.validatePreconditions();
        TaskInfoExtension config = this.getConfig();
        TaskProbe taskProbe = this.buildTaskProbe(config);
        TaskInfoDto taskInfo = taskProbe.buildHierarchy(this.getEntryNode());
        this.outputTaskInfo(taskInfo, config);
        if (taskProbe.isNonTaskNodesPresent() && config.isInternal()) {
            this.printHintOnInternalNodes("Nodes", config.isColor());
        }
        if (taskProbe.isAnyTaskFromAnotherBuild()) {
            String msg = "The above includes at least one task from another build. Tasks from the included build(s) have probably been executed,\nand may not show their dependencies here. You are seeing this because taskinfo.disableSafeguard=true.";
            this.getLogger().lifecycle(msg);
        }
    }

    public TaskProbe buildTaskProbe(TaskInfoExtension pConfig) {
        return new TaskProbe(this.getProject(), pConfig);
    }

    private void outputTaskInfo(TaskInfoDto pTaskInfo, TaskInfoExtension pConfig) {
        TreeOptions options = this.buildTreeOptions(pConfig);
        String tree = TextTree.newInstance(options).render(pTaskInfo);
        this.getLogger().lifecycle(tree);
    }

    @Nonnull
    private TreeOptions buildTreeOptions(@Nonnull TaskInfoExtension pConfig) {
        TreeOptions options = new TreeOptions();
        options.setAnnotationPosition(pConfig.isShowTaskTypes() ? AnnotationPosition.Aligned : AnnotationPosition.None);
        options.setEnableDefaultColoring(pConfig.isColor());
        options.setIdentityScheme(IdentityScheme.ByKey);
        options.setCycleProtection(pConfig.isClipped() ? CycleProtection.PruneRepeating : CycleProtection.On);
        options.setCycleAsPruned(true);
        return options;
    }
}

