/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.barfuin.gradle.taskinfo.ColorizableAppender;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.tasks.TaskAction;
import ti2-2-0.org.apache.commons.lang3.StringUtils;

public class TaskInfoOrderTask
extends AbstractInfoTask {
    public TaskInfoOrderTask() {
        this.setDescription("Displays which tasks would be executed in what order for a given task, and their task types.");
    }

    @Override
    @TaskAction
    public void executeTaskInfo() {
        this.validatePreconditions();
        TaskInfoExtension config = this.getConfig();
        TaskProbe taskProbe = new TaskProbe(this.getProject(), config);
        List<TaskNodeHolder> taskInfos = taskProbe.buildOrder();
        this.outputTaskInfo(taskInfos, config);
        if (taskProbe.isNonTaskNodesPresent() && config.isInternal()) {
            this.printHintOnInternalNodes("Items", config.isColor());
        }
        if (!this.getProject().getGradle().getIncludedBuilds().isEmpty()) {
            String msg = "The above may be missing information on tasks from included builds. The tiTree task may have a little more information. You are seeing this because taskinfo.disableSafeguard=true.";
            this.getLogger().lifecycle(msg);
        }
    }

    private void outputTaskInfo(List<TaskNodeHolder> pTaskInfos, TaskInfoExtension pConfig) {
        String output = this.renderTaskInfo(pTaskInfos, pConfig);
        this.getLogger().lifecycle(output);
    }

    private String renderTaskInfo(List<TaskNodeHolder> pTaskInfos, TaskInfoExtension pConfig) {
        int m = this.getLengthOfLongestTaskName(pTaskInfos);
        ColorizableAppender appender = new ColorizableAppender(pConfig.isColor());
        appender.newline();
        appender.append("In order to execute [");
        appender.append(this.getEntryNodeLabel());
        appender.append("], the following tasks would be executed in this order:");
        appender.newline();
        appender.newline();
        for (int i = 0; i < pTaskInfos.size(); ++i) {
            TaskNodeHolder taskInfo = pTaskInfos.get(i);
            String path = taskInfo.getIdentity();
            appender.colorNumbers();
            appender.append(String.format("%3d", i + 1));
            appender.append('.');
            appender.colorReset();
            appender.append(' ');
            if (taskInfo.getTask() == null) {
                appender.colorAnnotations();
            }
            appender.append(path);
            if (taskInfo.getTask() == null) {
                appender.colorReset();
            }
            if (pConfig.isShowTaskTypes()) {
                appender.append(StringUtils.repeat(' ', m - path.length() + 1));
                appender.colorAnnotations();
                appender.append('(');
                appender.append(taskInfo.getType().getName());
                appender.append(')');
                appender.colorReset();
            }
            appender.newline();
        }
        return appender.toString();
    }

    private int getLengthOfLongestTaskName(List<TaskNodeHolder> pTaskInfos) {
        return Collections.max(pTaskInfos, Comparator.comparing(dto -> dto.getIdentity().length())).getIdentity().length();
    }
}

