/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import ti2-2-0.com.fasterxml.jackson.databind.ObjectMapper;

public class TaskInfoJsonTask
extends AbstractInfoTask {
    private TaskInfoDto taskInfoData = null;
    private File outputFile = null;

    public TaskInfoJsonTask() {
        this.setDescription("Creates a JSON file with task dependencies of a given task, and their task types.");
    }

    @Override
    public void setEntryNode(TaskNodeHolder pEntryNode) {
        super.setEntryNode(pEntryNode);
        Task entryTask = pEntryNode.getTask();
        this.outputFile = new File(this.getProject().getBuildDir(), "taskinfo/taskinfo-" + (entryTask != null ? entryTask.getName() : "null") + ".json");
    }

    @Override
    @TaskAction
    public void executeTaskInfo() {
        this.validatePreconditions();
        try {
            Files.createDirectories(this.outputFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GradleException("Failed to create directory: " + this.outputFile.getParentFile().getAbsolutePath(), (Throwable)e);
        }
        TaskInfoExtension probeConfig = this.getConfig();
        probeConfig.setColor(false);
        this.taskInfoData = new TaskProbe(this.getProject(), probeConfig).buildHierarchy(this.getEntryNode());
        this.outputTaskInfo();
    }

    private void outputTaskInfo() {
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(this.outputFile, (Object)this.taskInfoData);
        }
        catch (IOException | RuntimeException e) {
            throw new GradleException("Failed to write output JSON file: " + this.outputFile.getAbsolutePath(), (Throwable)e);
        }
    }

    @Internal
    public TaskInfoDto getTaskInfoData() {
        return this.taskInfoData;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }
}

