/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.util.GradleVersionUtil;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import ti2-2-0.org.fusesource.jansi.Ansi;

public abstract class AbstractInfoTask
extends DefaultTask {
    private TaskNodeHolder entryNode = null;
    private String entryNodeLabel = "<unknown>";

    protected AbstractInfoTask() {
        this.getOutputs().upToDateWhen(task -> false);
    }

    public abstract void executeTaskInfo();

    protected void validatePreconditions() {
        GradleVersionUtil.validateMinimumGradleVersion(this.getName());
        if (this.entryNode == null) {
            throw new GradleException("No task specified for tiTree.");
        }
    }

    @Nonnull
    @Internal
    protected TaskInfoExtension getConfig() {
        Project project = this.getProject();
        TaskInfoExtension result = (TaskInfoExtension)project.getExtensions().getByType(TaskInfoExtension.class);
        if (project.hasProperty("taskinfo.clipped")) {
            result.setClipped(Boolean.parseBoolean(project.getProperties().get("taskinfo.clipped").toString()));
        }
        if (project.hasProperty("taskinfo.color")) {
            result.setColor(Boolean.parseBoolean(project.getProperties().get("taskinfo.color").toString()));
        }
        if (project.hasProperty("taskinfo.showTaskTypes")) {
            result.setShowTaskTypes(Boolean.parseBoolean(project.getProperties().get("taskinfo.showTaskTypes").toString()));
        }
        if (project.hasProperty("taskinfo.internal")) {
            result.setInternal(Boolean.parseBoolean(project.getProperties().get("taskinfo.internal").toString()));
        }
        return result;
    }

    public void setEntryNode(TaskNodeHolder pEntryNode) {
        this.entryNode = pEntryNode;
    }

    @Internal
    protected TaskNodeHolder getEntryNode() {
        return this.entryNode;
    }

    public void setEntryNodeLabel(String pEntryNodeLabel) {
        this.entryNodeLabel = pEntryNodeLabel != null ? pEntryNodeLabel : "<unknown>";
    }

    @Nonnull
    @Internal
    public String getEntryNodeLabel() {
        return this.entryNodeLabel;
    }

    protected void printHintOnInternalNodes(@Nonnull String pSubject, boolean pIsColor) {
        String msg = pIsColor ? Ansi.ansi().a(pSubject + " in ").fgBrightBlack().a("gray").reset().a(" are not backed by tasks but by internal nodes added by Gradle.").toString() : "The above includes internal nodes added by Gradle which are not backed by tasks.";
        this.getLogger().lifecycle(msg);
    }
}

