/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.TaskInfoSorting;
import ti2-2-0.com.fasterxml.jackson.annotation.JsonIgnore;
import ti2-2-0.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import ti2-2-0.com.fasterxml.jackson.annotation.JsonInclude;
import ti2-2-0.com.fasterxml.jackson.annotation.JsonProperty;
import ti2-2-0.org.barfuin.texttree.api.Node;
import ti2-2-0.org.barfuin.texttree.api.color.NodeColor;

@JsonIgnoreProperties(value={"annotation", "color", "annotationColor", "text", "key", "children"})
public class TaskInfoDto
implements Comparable<TaskInfoDto>,
Node {
    private static final TaskInfoSorting TASK_INFO_SORTING = new TaskInfoSorting();
    @JsonProperty
    private String name;
    @JsonProperty
    private String path;
    @JsonProperty
    private boolean finalizer;
    @JsonProperty
    private String group;
    @JsonProperty
    private String type;
    @JsonProperty
    private int queuePosition = -1;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final SortedSet<TaskInfoDto> dependencies = new TreeSet<TaskInfoDto>();
    @JsonIgnore
    private final boolean isTaskNode;
    @JsonIgnore
    private final boolean colored;

    public TaskInfoDto(String pPath, boolean pFinalizer, boolean pIsTaskNode, boolean pColored) {
        this.path = Objects.requireNonNull(pPath, "required argument pPath was null");
        this.finalizer = pFinalizer;
        this.isTaskNode = pIsTaskNode;
        this.colored = pColored;
    }

    public TaskInfoDto(String pPath, boolean pFinalizer) {
        this(pPath, pFinalizer, true, false);
    }

    public TaskInfoDto() {
        this("", false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nonnull String pPath) {
        this.path = Objects.requireNonNull(pPath, "required argument pPath was null");
    }

    boolean isTaskNode() {
        return this.isTaskNode;
    }

    @Override
    @CheckForNull
    public NodeColor getColor() {
        return this.isTaskNode || !this.colored ? null : NodeColor.DarkGray;
    }

    public boolean isFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(boolean pFinalizer) {
        this.finalizer = pFinalizer;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String pGroup) {
        this.group = pGroup;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String pType) {
        this.type = pType;
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public void setQueuePosition(int pQueuePosition) {
        this.queuePosition = pQueuePosition;
    }

    @Nonnull
    public SortedSet<TaskInfoDto> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(TaskInfoDto pNewDependency) {
        Objects.requireNonNull(pNewDependency, "argument pNewDependency was null");
        this.dependencies.add(pNewDependency);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null || this.getClass() != pOther.getClass()) {
            return false;
        }
        return this.compareTo((TaskInfoDto)pOther) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.finalizer, this.path);
    }

    @Override
    public int compareTo(@Nonnull TaskInfoDto pOther) {
        return TASK_INFO_SORTING.compare(this, pOther);
    }

    @Override
    public String getText() {
        return this.path + (this.finalizer ? " (finalizer)" : "");
    }

    @Override
    public String getKey() {
        return this.path;
    }

    @Override
    @CheckForNull
    public String getAnnotation() {
        return '(' + this.getType() + ')';
    }

    @Nonnull
    public SortedSet<TaskInfoDto> getChildren() {
        return this.dependencies;
    }
}

