/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.tools.ant.BuildException;
import org.barfuin.gradle.taskinfo.EntryNodeProvider;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.tasks.TaskInfoJsonTask;
import org.barfuin.gradle.taskinfo.tasks.TaskInfoOrderTask;
import org.barfuin.gradle.taskinfo.tasks.TaskInfoTreeTask;
import org.barfuin.gradle.taskinfo.util.GradleVersionUtil;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class GradleTaskInfoPlugin
implements Plugin<Project> {
    public static final String PLUGIN_ID = "org.barfuin.gradle.taskinfo";
    public static final String TASKINFO_TASK_NAME = "tiTree";
    public static final String TASKINFO_JSON_TASK_NAME = "tiJson";
    public static final String TASKINFO_ORDERED_TASK_NAME = "tiOrder";
    public static final String TASKINFO_EXT_NAME = "taskinfo";

    public void apply(@Nonnull Project pProject) {
        this.checkforIncludedBuilds(pProject);
        TaskContainer tasks = pProject.getTasks();
        pProject.getExtensions().create(TASKINFO_EXT_NAME, TaskInfoExtension.class, new Object[0]);
        if (GradleVersionUtil.isDeferredConfigSupported()) {
            pProject.getLogger().debug("Using deferred configuration with Gradle " + GradleVersionUtil.getDeferredConfigMinVersion() + " or newer");
            ArrayList<TaskProvider> ourTasks = new ArrayList<TaskProvider>();
            ourTasks.add(tasks.register(TASKINFO_TASK_NAME, TaskInfoTreeTask.class));
            ourTasks.add(tasks.register(TASKINFO_ORDERED_TASK_NAME, TaskInfoOrderTask.class));
            ourTasks.add(tasks.register(TASKINFO_JSON_TASK_NAME, TaskInfoJsonTask.class));
            pProject.getGradle().getTaskGraph().whenReady(executionGraph -> {
                EntryNodeProvider ep = new EntryNodeProvider(pProject, (TaskExecutionGraph)executionGraph);
                ourTasks.forEach(provider -> {
                    provider.configure(t -> this.configureEntryNode(ep, Collections.singletonList(t)));
                    provider.configure(t -> this.disableAllNormalTasks((TaskExecutionGraph)executionGraph, Collections.singletonList(t)));
                });
            });
        } else {
            pProject.getLogger().debug("Deferred configuration unavailable because Gradle older than " + GradleVersionUtil.getDeferredConfigMinVersion());
            ArrayList<Task> ourTasks = new ArrayList<Task>();
            ourTasks.add(tasks.create(TASKINFO_TASK_NAME, TaskInfoTreeTask.class));
            ourTasks.add(tasks.create(TASKINFO_JSON_TASK_NAME, TaskInfoJsonTask.class));
            ourTasks.add(tasks.create(TASKINFO_ORDERED_TASK_NAME, TaskInfoOrderTask.class));
            pProject.getGradle().getTaskGraph().whenReady(executionGraph -> {
                EntryNodeProvider ep = new EntryNodeProvider(pProject, (TaskExecutionGraph)executionGraph);
                this.configureEntryNode(ep, ourTasks);
                this.disableAllNormalTasks((TaskExecutionGraph)executionGraph, (List<AbstractInfoTask>)ourTasks);
            });
        }
    }

    private void checkforIncludedBuilds(@Nonnull Project pProject) {
        if (this.isSafeguardActive(pProject) && !pProject.getGradle().getIncludedBuilds().isEmpty()) {
            throw new GradleException("The plugin 'org.barfuin.gradle.taskinfo' does not support composite builds at this time.\nYou can still run it by adding -Ptaskinfo.disableSafeguard=true to your Gradle invocation.In that case, tasks from the included builds will be executed.");
        }
    }

    private boolean isSafeguardActive(@Nonnull Project pProject) {
        boolean disabled = false;
        try {
            Object v = pProject.getProperties().get("taskinfo.disableSafeguard");
            disabled = v instanceof String && Boolean.parseBoolean((String)v);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        return !disabled;
    }

    private void disableAllNormalTasks(TaskExecutionGraph pExecutionGraph, List<AbstractInfoTask> pOurTasks) {
        AbstractInfoTask ourTask = this.findAnyOfOurTasks(pExecutionGraph, pOurTasks);
        if (ourTask != null) {
            GradleVersionUtil.validateMinimumGradleVersion(ourTask.getName());
            pExecutionGraph.getAllTasks().forEach(task -> {
                if (!(task instanceof AbstractInfoTask)) {
                    task.setEnabled(false);
                }
            });
        }
    }

    private void configureEntryNode(EntryNodeProvider pEntryNodeProvider, List<AbstractInfoTask> pOurTasks) {
        TaskNodeHolder entryNode = pEntryNodeProvider.getEffectiveEntryNode();
        String label = pEntryNodeProvider.getLabel();
        for (AbstractInfoTask ourTask : pOurTasks) {
            ourTask.setEntryNode(entryNode);
            ourTask.setEntryNodeLabel(label);
        }
    }

    @CheckForNull
    private AbstractInfoTask findAnyOfOurTasks(TaskExecutionGraph pExecutionGraph, List<AbstractInfoTask> pOurTasks) {
        AbstractInfoTask result = null;
        for (AbstractInfoTask ourTask : pOurTasks) {
            if (!pExecutionGraph.hasTask((Task)ourTask)) continue;
            result = ourTask;
            break;
        }
        return result;
    }
}

