/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.util.ReflectUtil;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;

public class EntryNodeProvider {
    private final Project project;
    private final TaskExecutionGraph taskGraph;
    private final SortedSet<String> entryNodePaths = new TreeSet<String>();
    private final List<TaskNodeHolder> entryNodes = new ArrayList<TaskNodeHolder>();
    private String invokedTask = null;

    public EntryNodeProvider(@Nonnull Project pProject, @Nonnull TaskExecutionGraph pTaskGraph) {
        this.project = Objects.requireNonNull(pProject, "pProject was null");
        this.taskGraph = Objects.requireNonNull(pTaskGraph, "pTaskGraph was null");
        this.analyzeTaskGraph();
    }

    private void analyzeTaskGraph() {
        Object executionPlan = ReflectUtil.getExecutionPlan(this.taskGraph);
        Iterable rawEntryNodes = (Iterable)ReflectUtil.readField(executionPlan, "list of invoked tasks", Arrays.asList("entryNodes", "entryTasks"));
        this.invokedTask = this.readInvokedTaskname(rawEntryNodes);
        this.processEntryNodes(rawEntryNodes);
    }

    private void processEntryNodes(@Nonnull Iterable<?> pEntryNodes) {
        boolean taskInfoInvoked = false;
        for (Object realNode : pEntryNodes) {
            TaskNodeHolder holder = new TaskNodeHolder(this.project, realNode);
            if (holder.isOneOfOurTasks()) {
                taskInfoInvoked = true;
                continue;
            }
            this.entryNodes.add(holder);
            this.entryNodePaths.add(holder.getIdentity());
        }
        if (this.entryNodes.isEmpty()) {
            throw new GradleException("No task specified for " + this.invokedTask + ".");
        }
        if (taskInfoInvoked && this.entryNodes.size() > 1 && !"tiOrder".equals(this.invokedTask)) {
            this.project.getLogger().warn("WARNING: More than one task specified as argument of " + this.invokedTask + " " + this.entryNodePaths + ". Will report on '" + this.entryNodes.get(0).getIdentity() + "'.");
        }
    }

    @Nonnull
    private String readInvokedTaskname(@Nonnull Iterable<?> pEntryNodes) {
        TreeSet<String> candidates = new TreeSet<String>();
        for (Object realNode : pEntryNodes) {
            TaskNodeHolder holder = new TaskNodeHolder(this.project, realNode);
            if (!holder.isOneOfOurTasks()) continue;
            candidates.add(holder.getDisplayName());
        }
        return candidates.size() == 1 ? (String)candidates.first() : "task info";
    }

    @Nonnull
    public TaskNodeHolder getEffectiveEntryNode() {
        return this.entryNodes.get(0);
    }

    @Nonnull
    public String getLabel() {
        return String.join((CharSequence)", ", this.entryNodePaths);
    }
}

