/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import ti2-2-0.org.fusesource.jansi.Ansi;

public class ColorizableAppender {
    private final StringBuilder sb = new StringBuilder();
    private final Ansi ansi = Ansi.ansi(this.sb);
    private final boolean colorized;

    public ColorizableAppender(boolean pColorized) {
        this.colorized = pColorized;
    }

    public void append(char pChar) {
        if (this.colorized) {
            this.ansi.a(pChar);
        } else {
            this.sb.append(pChar);
        }
    }

    public void append(String pText) {
        if (this.colorized) {
            this.ansi.a(pText);
        } else {
            this.sb.append(pText);
        }
    }

    public void newline() {
        if (this.colorized) {
            this.ansi.newline();
        } else {
            this.sb.append(System.lineSeparator());
        }
    }

    public void colorNumbers() {
        if (this.colorized) {
            this.ansi.fgYellow();
        }
    }

    public void colorAnnotations() {
        if (this.colorized) {
            this.ansi.fgBrightBlack();
        }
    }

    public void colorReset() {
        if (this.colorized) {
            this.ansi.reset();
        }
    }

    public String toString() {
        if (this.colorized) {
            return this.ansi.toString();
        }
        return this.sb.toString();
    }
}

