/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;

@Priority(value=0x3FFFFFFF)
public class SpringBeanDependencyResolverFactory
implements ParameterResolverFactory {
    private final ApplicationContext applicationContext;

    public SpringBeanDependencyResolverFactory(@NonNull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ParameterResolver<?> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Optional ann = AnnotationUtils.findAnnotationAttribute((AnnotatedElement)parameters[parameterIndex], Autowired.class, (String)"required");
        if (!ann.isPresent()) {
            return null;
        }
        boolean required = (Boolean)ann.get();
        MethodParameter methodParameter = executable instanceof Method ? new MethodParameter((Method)executable, parameterIndex) : new MethodParameter((Constructor)executable, parameterIndex);
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParameter, required);
        return new SpringBeanDependencyResolver(this.applicationContext.getAutowireCapableBeanFactory(), dependencyDescriptor);
    }

    private static class SpringBeanDependencyResolver
    implements ParameterResolver<Object> {
        private final AutowireCapableBeanFactory beanFactory;
        private final DependencyDescriptor dependencyDescriptor;

        public SpringBeanDependencyResolver(AutowireCapableBeanFactory beanFactory, DependencyDescriptor dependencyDescriptor) {
            this.beanFactory = beanFactory;
            this.dependencyDescriptor = dependencyDescriptor;
        }

        @Nonnull
        public CompletableFuture<Object> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(this.beanFactory.resolveDependency(this.dependencyDescriptor, null));
        }

        public boolean matches(@Nonnull ProcessingContext context) {
            return true;
        }
    }
}

