/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.common.annotation.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

@Internal
public class SpringLifecycleShutdownHandler
implements SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int phase;
    private final Supplier<CompletableFuture<?>> task;
    private final AtomicBoolean running = new AtomicBoolean(false);

    SpringLifecycleShutdownHandler(int phase, @Nonnull Supplier<CompletableFuture<?>> task) {
        this.phase = phase;
        this.task = task;
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        try {
            ((CompletableFuture)this.task.get().whenComplete((result, throwable) -> this.running.set(false))).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    public void stop(@Nonnull Runnable callback) {
        this.task.get().whenComplete((result, throwable) -> {
            if (throwable != null) {
                logger.warn("Failed running shutdown task [{}] in phase [{}].", new Object[]{this.task, this.phase, throwable});
            }
            this.running.set(false);
            callback.run();
        });
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return this.phase;
    }
}

