/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.messaging;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extension.spring.messaging.DefaultEventMessageConverter;
import org.axonframework.extension.spring.messaging.EventMessageConverter;
import org.axonframework.messaging.SubscribableEventSource;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class OutboundEventMessageChannelAdapter
implements InitializingBean {
    private final MessageChannel channel;
    private final Predicate<? super EventMessage> filter;
    private final SubscribableEventSource eventSource;
    private final EventMessageConverter eventMessageConverter;

    public OutboundEventMessageChannelAdapter(@Nonnull SubscribableEventSource eventSource, @Nonnull MessageChannel channel) {
        this(eventSource, channel, m -> true);
    }

    public OutboundEventMessageChannelAdapter(@Nonnull SubscribableEventSource eventSource, @Nonnull MessageChannel channel, Predicate<? super EventMessage> filter) {
        this(eventSource, channel, filter, new DefaultEventMessageConverter());
    }

    public OutboundEventMessageChannelAdapter(@Nonnull SubscribableEventSource eventSource, @Nonnull MessageChannel channel, Predicate<? super EventMessage> filter, @Nonnull EventMessageConverter eventMessageConverter) {
        this.channel = Objects.requireNonNull(channel, "MessageChannel may not be null.");
        this.eventSource = Objects.requireNonNull(eventSource, "SubscribableEventSource may not be null.");
        this.filter = Objects.requireNonNull(filter, "Filter may not be null.");
        this.eventMessageConverter = Objects.requireNonNull(eventMessageConverter, "EventMessageConverter may not be null.");
    }

    public void afterPropertiesSet() {
        this.eventSource.subscribe((events, context) -> {
            this.handle((List<? extends EventMessage>)events, (ProcessingContext)context);
            return CompletableFuture.completedFuture(null);
        });
    }

    protected void handle(List<? extends EventMessage> events, ProcessingContext context) {
        events.stream().filter(this.filter::test).forEach(event -> this.channel.send(this.transform((EventMessage)event)));
    }

    protected Message transform(EventMessage event) {
        return this.eventMessageConverter.convertToOutboundMessage(event);
    }
}

