/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.messaging;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.extension.spring.messaging.EventMessageConverter;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.springframework.messaging.MessageHeaders;

public class DefaultEventMessageConverter
implements EventMessageConverter {
    private static final String AXON_MESSAGE_PREFIX = "axon-message-";
    private static final String MESSAGE_ID = "axon-message-id";
    private static final String MESSAGE_TYPE = "axon-message-type";
    private static final String AGGREGATE_ID = "axon-message-aggregate-id";
    private static final String AGGREGATE_SEQ = "axon-message-aggregate-seq";
    private static final String AGGREGATE_TYPE = "axon-message-aggregate-type";

    @Override
    public <T> org.springframework.messaging.Message convertToOutboundMessage(EventMessage event) {
        HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)event.metadata());
        headers.put(MESSAGE_ID, event.identifier());
        headers.put(MESSAGE_TYPE, event.type().toString());
        return new org.springframework.messaging.support.GenericMessage(event.payload(), (MessageHeaders)new SettableTimestampMessageHeaders(headers, event.timestamp().toEpochMilli()));
    }

    @Override
    public <T> EventMessage convertFromInboundMessage(org.springframework.messaging.Message message) {
        MessageHeaders headers = message.getHeaders();
        Map<String, String> metadata = headers.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(AXON_MESSAGE_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        String messageId = Objects.toString(headers.get((Object)MESSAGE_ID));
        MessageType type = DefaultEventMessageConverter.getType(message);
        Long timestamp = headers.getTimestamp();
        GenericMessage genericMessage = new GenericMessage(messageId, type, message.getPayload(), metadata);
        return new GenericEventMessage((Message)genericMessage, () -> Instant.ofEpochMilli(timestamp));
    }

    private static <T> MessageType getType(org.springframework.messaging.Message message) {
        MessageHeaders headers = message.getHeaders();
        return headers.containsKey((Object)MESSAGE_TYPE) ? MessageType.fromString((String)Objects.toString(headers.get((Object)MESSAGE_TYPE))) : new MessageType(message.getClass());
    }

    private static class SettableTimestampMessageHeaders
    extends MessageHeaders {
        protected SettableTimestampMessageHeaders(Map<String, Object> headers, Long timestamp) {
            super(headers, null, timestamp);
        }
    }
}

