/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.processors.streaming.pooled.PooledStreamingEventProcessorConfiguration;
import org.axonframework.eventhandling.processors.streaming.pooled.PooledStreamingEventProcessorModule;
import org.axonframework.eventhandling.processors.streaming.token.store.TokenStore;
import org.axonframework.eventhandling.processors.subscribing.SubscribingEventProcessorConfiguration;
import org.axonframework.eventhandling.processors.subscribing.SubscribingEventProcessorModule;
import org.axonframework.eventstreaming.StreamableEventSource;
import org.axonframework.extension.spring.config.EventProcessorSettings;
import org.axonframework.messaging.SubscribableEventSource;

interface SpringCustomizations {
    public static PooledStreamingEventProcessorModule.Customization pooledStreamingCustomizations(String name, EventProcessorSettings.PooledEventProcessorSettings settings) {
        return new SpringPooledStreamingEventProcessingModuleCustomization(name, settings);
    }

    public static SubscribingEventProcessorModule.Customization subscribingCustomizations(String name, EventProcessorSettings.SubscribingEventProcessorSettings settings) {
        return new SpringSubscribingEventProcessingModuleCustomization(name, settings);
    }

    @Nullable
    public static <T> T getComponent(@Nonnull Configuration configuration, @Nonnull Class<T> type, @Nullable String name, @Nullable Supplier<T> supplier) {
        Supplier<Object> safeSupplier = supplier != null ? supplier : () -> null;
        return configuration.getOptionalComponent(type, name).orElseGet(safeSupplier);
    }

    public static void require(boolean condition, String message) {
        if (!condition) {
            throw new AxonConfigurationException(message);
        }
    }

    public static class SpringPooledStreamingEventProcessingModuleCustomization
    implements PooledStreamingEventProcessorModule.Customization {
        private final EventProcessorSettings.PooledEventProcessorSettings settings;
        private final String name;

        SpringPooledStreamingEventProcessingModuleCustomization(String name, EventProcessorSettings.PooledEventProcessorSettings settings) {
            this.settings = settings;
            this.name = name;
        }

        public PooledStreamingEventProcessorConfiguration apply(Configuration configuration, PooledStreamingEventProcessorConfiguration eventProcessorConfiguration) {
            String executorName = "WorkPackage[" + this.name + "]";
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(this.settings.threadCount(), (ThreadFactory)new AxonThreadFactory(executorName));
            StreamableEventSource eventStore = SpringCustomizations.getComponent(configuration, StreamableEventSource.class, this.settings.source(), null);
            SpringCustomizations.require(eventStore != null, "Could not find a mandatory Source with name '" + this.settings.source() + "' for event processor '" + this.name + "'.");
            TokenStore tokenStore = SpringCustomizations.getComponent(configuration, TokenStore.class, this.settings.tokenStore(), null);
            SpringCustomizations.require(tokenStore != null, "Could not find a mandatory TokenStore with name '" + this.settings.tokenStore() + "' for event processor '" + this.name + "'.");
            return eventProcessorConfiguration.workerExecutor(scheduledExecutorService).tokenClaimInterval(this.settings.tokenClaimIntervalInMillis()).batchSize(this.settings.batchSize()).initialSegmentCount(this.settings.initialSegmentCount()).eventSource(eventStore).tokenStore(tokenStore);
        }
    }

    public static class SpringSubscribingEventProcessingModuleCustomization
    implements SubscribingEventProcessorModule.Customization {
        private final EventProcessorSettings.SubscribingEventProcessorSettings settings;
        private final String name;

        SpringSubscribingEventProcessingModuleCustomization(String name, EventProcessorSettings.SubscribingEventProcessorSettings settings) {
            this.name = name;
            this.settings = settings;
        }

        public SubscribingEventProcessorConfiguration apply(Configuration configuration, SubscribingEventProcessorConfiguration subscribingEventProcessorConfiguration) {
            SubscribableEventSource messageSource = SpringCustomizations.getComponent(configuration, SubscribableEventSource.class, this.settings.source(), null);
            SpringCustomizations.require(messageSource != null, "Could not find a mandatory Source with name '" + this.settings.source() + "' for event processor '" + this.name + "'.");
            return subscribingEventProcessorConfiguration.eventSource(messageSource);
        }
    }
}

