/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.authorization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageDispatchInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class MessageAuthorizationDispatchInterceptor<T extends Message>
implements MessageDispatchInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageAuthorizationDispatchInterceptor.class);
    private final Converter converter;

    public MessageAuthorizationDispatchInterceptor(@Nonnull Converter converter) {
        this.converter = Objects.requireNonNull(converter, "Converter must not be null.");
    }

    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull T message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<T> interceptorChain) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("No authentication found.");
            return interceptorChain.proceed(message, context);
        }
        logger.debug("Adding message metadata for username & authorities.");
        HashMap<String, String> authenticationDetails = new HashMap<String, String>();
        authenticationDetails.put("username", (String)this.converter.convert(authentication.getPrincipal(), String.class));
        String authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        authenticationDetails.put("authorities", authorities);
        return interceptorChain.proceed(message.andMetadata(authenticationDetails), context);
    }
}

