/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManagerFactory;
import java.time.Duration;
import java.util.function.UnaryOperator;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.SearchScope;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.eventsourcing.eventstore.EventCoordinator;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.jpa.AggregateBasedJpaEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.JpaPollingEventCoordinator;
import org.axonframework.extension.springboot.JpaEventStorageEngineConfigurationProperties;
import org.axonframework.extension.springboot.autoconfig.AxonServerAutoConfiguration;
import org.axonframework.extension.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.extension.springboot.util.RegisterDefaultEntities;
import org.axonframework.messaging.core.unitofwork.transaction.TransactionManager;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(after={HibernateJpaAutoConfiguration.class, AxonServerAutoConfiguration.class, JpaAutoConfiguration.class})
@ConditionalOnBean(value={EntityManagerFactory.class, PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={EventStore.class, EventStorageEngine.class})
@RegisterDefaultEntities(packages={"org.axonframework.eventsourcing.eventstore.jpa"})
@EnableConfigurationProperties(value={JpaEventStorageEngineConfigurationProperties.class})
public class JpaEventStoreAutoConfiguration {
    @Bean
    public ConfigurationEnhancer aggregateBasedJpaEventStorageEngine(EntityManagerProvider entityManagerProvider, PersistenceExceptionResolver persistenceExceptionResolver, JpaEventStorageEngineConfigurationProperties jpaEventStorageEngineConfigurationProperties) {
        return new AggregateBasedJpaEventStorageEngineConfigurationEnhancer(jpaEventStorageEngineConfigurationProperties, entityManagerProvider, persistenceExceptionResolver);
    }

    public record AggregateBasedJpaEventStorageEngineConfigurationEnhancer(JpaEventStorageEngineConfigurationProperties properties, EntityManagerProvider entityManagerProvider, PersistenceExceptionResolver persistenceExceptionResolver) implements ConfigurationEnhancer
    {
        public void enhance(@Nonnull ComponentRegistry registry) {
            UnaryOperator configurer = config -> config.batchSize(this.properties.batchSize()).gapCleaningThreshold(this.properties.gapCleaningThreshold()).gapTimeout(this.properties.gapTimeout()).lowestGlobalSequence(this.properties.lowestGlobalSequence()).maxGapOffset(this.properties.maxGapOffset()).persistenceExceptionResolver(this.persistenceExceptionResolver).eventCoordinator((EventCoordinator)(this.properties.pollingInterval() == 0L ? EventCoordinator.SIMPLE : new JpaPollingEventCoordinator(this.entityManagerProvider, Duration.ofMillis(this.properties.pollingInterval()))));
            registry.registerIfNotPresent(EventStorageEngine.class, configuration -> new AggregateBasedJpaEventStorageEngine(this.entityManagerProvider, (TransactionManager)configuration.getComponent(TransactionManager.class), (EventConverter)configuration.getComponent(EventConverter.class), configurer), SearchScope.ALL);
        }

        public int order() {
            return 2147483047;
        }
    }
}

