/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManagerFactory;
import java.sql.SQLException;
import java.time.temporal.TemporalAmount;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.conversion.Converter;
import org.axonframework.conversion.json.JacksonConverter;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.extension.springboot.TokenStoreProperties;
import org.axonframework.extension.springboot.util.RegisterDefaultEntities;
import org.axonframework.extension.springboot.util.jpa.ContainerManagedEntityManagerProvider;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.TokenStore;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.jpa.JpaTokenStore;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.jpa.JpaTokenStoreConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(afterName={"org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration"})
@ConditionalOnClass(value={EntityManagerFactory.class})
@ConditionalOnBean(value={EntityManagerFactory.class})
@EnableConfigurationProperties(value={TokenStoreProperties.class})
@RegisterDefaultEntities(packages={"org.axonframework.messaging.eventhandling.processing.streaming.token.store.jpa"})
public class JpaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public EntityManagerProvider entityManagerProvider() {
        return new ContainerManagedEntityManagerProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenStore tokenStore(EntityManagerProvider entityManagerProvider, TokenStoreProperties tokenStoreProperties, ObjectMapper defaultAxonObjectMapper) {
        JpaTokenStoreConfiguration config = JpaTokenStoreConfiguration.DEFAULT.claimTimeout((TemporalAmount)tokenStoreProperties.getClaimTimeout());
        JacksonConverter converter = new JacksonConverter(defaultAxonObjectMapper);
        return new JpaTokenStore(entityManagerProvider, (Converter)converter, config);
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistenceExceptionResolver persistenceExceptionResolver(DataSource dataSource) throws SQLException {
        return new SQLErrorCodesResolver(dataSource);
    }
}

