/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.axonframework.extension.spring.config.EventProcessorSettings;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="axon.eventhandling")
public class EventProcessorProperties {
    private final Map<String, ProcessorSettings> processors = new HashMap<String, ProcessorSettings>();

    public Map<String, ProcessorSettings> getProcessors() {
        return this.processors;
    }

    public static class DlqCache {
        private boolean enabled = false;
        private int size = 1024;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static class Dlq {
        private boolean enabled = false;
        private DlqCache cache = new DlqCache();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public DlqCache getCache() {
            return this.cache;
        }

        public void setCache(DlqCache cache) {
            this.cache = cache;
        }
    }

    public static class ProcessorSettings
    implements EventProcessorSettings.PooledEventProcessorSettings,
    EventProcessorSettings.SubscribingEventProcessorSettings {
        private String source;
        private Mode mode = Mode.POOLED;
        private int initialSegmentCount = 16;
        private long tokenClaimInterval = 5000L;
        private TimeUnit tokenClaimIntervalTimeUnit = TimeUnit.MILLISECONDS;
        private int threadCount = 4;
        private int batchSize = 1;
        private String tokenStore = "tokenStore";
        private String sequencingPolicy;
        private Dlq dlq = new Dlq();

        public String source() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Mode getMode() {
            return this.mode;
        }

        @Nonnull
        public EventProcessorSettings.ProcessorMode processorMode() {
            if (Mode.SUBSCRIBING.equals((Object)this.mode)) {
                return EventProcessorSettings.ProcessorMode.SUBSCRIBING;
            }
            return EventProcessorSettings.ProcessorMode.POOLED;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public int initialSegmentCount() {
            return this.initialSegmentCount;
        }

        public void setInitialSegmentCount(int initialSegmentCount) {
            this.initialSegmentCount = initialSegmentCount;
        }

        public long getTokenClaimInterval() {
            return this.tokenClaimInterval;
        }

        public void setTokenClaimInterval(long tokenClaimInterval) {
            this.tokenClaimInterval = tokenClaimInterval;
        }

        public TimeUnit getTokenClaimIntervalTimeUnit() {
            return this.tokenClaimIntervalTimeUnit;
        }

        public long tokenClaimIntervalInMillis() {
            return this.tokenClaimIntervalTimeUnit.toMillis(this.tokenClaimInterval);
        }

        public void setTokenClaimIntervalTimeUnit(TimeUnit tokenClaimIntervalTimeUnit) {
            this.tokenClaimIntervalTimeUnit = tokenClaimIntervalTimeUnit;
        }

        public int threadCount() {
            int defaultThreadCount = 1;
            return this.threadCount < 1 ? defaultThreadCount : this.threadCount;
        }

        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        public int batchSize() {
            int defaultBatchSize = 1;
            return this.batchSize < 1 ? defaultBatchSize : this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public void setTokenStore(@Nonnull String tokenStore) {
            Objects.requireNonNull(tokenStore, "TokenStore cannot be null");
            this.tokenStore = tokenStore;
        }

        @Nonnull
        public String tokenStore() {
            return this.tokenStore;
        }

        public String sequencingPolicy() {
            return this.sequencingPolicy;
        }

        public void setSequencingPolicy(String sequencingPolicy) {
            this.sequencingPolicy = sequencingPolicy;
        }

        public Dlq getDlq() {
            return this.dlq;
        }

        public void setDlq(Dlq dlq) {
            this.dlq = dlq;
        }
    }

    public static enum Mode {
        SUBSCRIBING,
        POOLED;

    }
}

