/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.service.connection;

import org.axonframework.extension.springboot.service.connection.AxonServerConnectionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

public class AxonServerDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<AxonServerConnectionDetails> {
    private static final Logger logger = LoggerFactory.getLogger(AxonServerDockerComposeConnectionDetailsFactory.class);

    public AxonServerDockerComposeConnectionDetailsFactory() {
        super("axoniq/axonserver", new String[]{"io.axoniq.axonserver.connector.AxonServerConnectionFactory"});
    }

    protected AxonServerConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        RunningService runningService = source.getRunningService();
        if (runningService == null) {
            return null;
        }
        int port = runningService.ports().get(8124);
        int uiPort = runningService.ports().get(8024);
        String host = runningService.host();
        logger.info("Detected Axon Server container. To access the dashboard, visit http://{}:{}", (Object)host, (Object)uiPort);
        return () -> host + ":" + port;
    }
}

