/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import io.axoniq.axonserver.connector.control.ControlChannel;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConfigurationEnhancer;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.TopologyChangeListener;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.DecoratorDefinition;
import org.axonframework.extension.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.extension.springboot.service.connection.AxonServerConnectionDetails;
import org.axonframework.messaging.commandhandling.distributed.DistributedCommandBusConfiguration;
import org.axonframework.messaging.queryhandling.distributed.DistributedQueryBusConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;

@AutoConfiguration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
@ConditionalOnClass(value={AxonServerConfiguration.class})
@EnableConfigurationProperties(value={AxonServerConfiguration.class})
public class AxonServerAutoConfiguration
implements ApplicationContextAware {
    public static final int AXON_SERVER_CONFIGURATION_ENHANCEMENT_ORDER = -100;
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.enabled"}, havingValue="false")
    public ConfigurationEnhancer disableAxonServerConfigurationEnhancer() {
        return new ConfigurationEnhancer(this){

            public void enhance(@Nonnull ComponentRegistry registry) {
                registry.disableEnhancer(AxonServerConfigurationEnhancer.class);
            }

            public int order() {
                return Integer.MIN_VALUE;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
    public ConfigurationEnhancer axonServerConfigurationEnhancer() {
        return registry -> registry.registerDecorator(AxonServerConfiguration.class, -100, (config, name, axonServerConfig) -> {
            axonServerConfig.setComponentName(AxonServerAutoConfiguration.clientName(this.applicationContext.getId()));
            return axonServerConfig;
        }).registerDecorator(DistributedCommandBusConfiguration.class, -100, (config, name, distributedCommandBusConfig) -> {
            AxonServerConfiguration serverConfig = (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class);
            int commandThreads = serverConfig.getCommandThreads();
            return distributedCommandBusConfig.commandThreads(commandThreads);
        }).registerDecorator(DistributedQueryBusConfiguration.class, -100, (config, name, distributedQueryBusConfig) -> {
            AxonServerConfiguration serverConfig = (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class);
            int queryThreads = serverConfig.getQueryThreads();
            int queryResponseThreads = serverConfig.getQueryResponseThreads();
            return distributedQueryBusConfig.queryThreads(queryThreads).queryResponseThreads(queryResponseThreads);
        });
    }

    private static String clientName(@Nullable String id) {
        if (id == null) {
            return "Unnamed";
        }
        if (id.contains(":")) {
            return id.substring(0, id.indexOf(":"));
        }
        return id;
    }

    @Bean
    @ConditionalOnBean(value={AxonServerConnectionDetails.class})
    @ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
    public ConfigurationEnhancer axonServerConfigurationWithConnectionDetails(AxonServerConnectionDetails connectionDetails) {
        return registry -> registry.registerDecorator(AxonServerConfiguration.class, -100, (config, name, axonServerConfig) -> {
            axonServerConfig.setServers(connectionDetails.routingServers());
            return axonServerConfig;
        });
    }

    @Bean
    @ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
    public ConfigurationEnhancer topologyChangeListenerConfigurerModule(List<TopologyChangeListener> changeListeners) {
        if (changeListeners.isEmpty()) {
            return registry -> {};
        }
        DecoratorDefinition topologyRegistrationDecorator = DecoratorDefinition.forType(AxonServerConnectionManager.class).with((config, name, delegate) -> delegate).onStart(0x40000009, connectionManager -> {
            ControlChannel defaultControlChannel = connectionManager.getConnection().controlChannel();
            changeListeners.forEach(arg_0 -> ((ControlChannel)defaultControlChannel).registerTopologyChangeHandler(arg_0));
        });
        return registry -> registry.registerDecorator(topologyRegistrationDecorator);
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

