/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import jakarta.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.extension.springboot.TimeoutProperties;
import org.axonframework.messaging.interceptors.HandlerInterceptorRegistry;
import org.axonframework.messaging.timeout.HandlerTimeoutHandlerEnhancerDefinition;
import org.axonframework.messaging.timeout.TaskTimeoutSettings;
import org.axonframework.messaging.timeout.UnitOfWorkTimeoutInterceptorBuilder;
import org.axonframework.queryhandling.QueryBus;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={TimeoutProperties.class})
@ConditionalOnProperty(prefix="axon.timeout", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AxonTimeoutAutoConfiguration {
    @Bean
    public HandlerTimeoutHandlerEnhancerDefinition messageTimeoutHandlerEnhancerDefinition(TimeoutProperties properties) {
        return new HandlerTimeoutHandlerEnhancerDefinition(properties.getHandler().toMessageHandlerTimeoutConfiguration());
    }

    @Bean
    public ConfigurationEnhancer axonTimeoutConfigurationEnhancer(@Nonnull TimeoutProperties properties) {
        return new AxonTimeoutConfigurerModule(properties.getTransaction());
    }

    private record AxonTimeoutConfigurerModule(@Nonnull TimeoutProperties.TransactionTimeoutProperties properties) implements ConfigurationEnhancer
    {
        public int order() {
            return Integer.MIN_VALUE;
        }

        public void enhance(@Nonnull ComponentRegistry registry) {
            registry.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventInterceptor(c -> {
                TaskTimeoutSettings settings = this.getSettingsForProcessor(name);
                return new UnitOfWorkTimeoutInterceptorBuilder("EventProcessor " + name, settings.getTimeoutMs(), settings.getWarningThresholdMs(), settings.getWarningIntervalMs()).buildEventInterceptor();
            }).registerCommandInterceptor(c -> new UnitOfWorkTimeoutInterceptorBuilder(((CommandBus)c.getComponent(CommandBus.class)).getClass().getSimpleName(), this.properties.getCommandBus().getTimeoutMs(), this.properties.getCommandBus().getWarningThresholdMs(), this.properties.getCommandBus().getWarningIntervalMs()).buildCommandInterceptor()).registerQueryInterceptor(c -> new UnitOfWorkTimeoutInterceptorBuilder(((QueryBus)c.getComponent(QueryBus.class)).getClass().getSimpleName(), this.properties.getQueryBus().getTimeoutMs(), this.properties.getQueryBus().getWarningThresholdMs(), this.properties.getQueryBus().getWarningIntervalMs()).buildQueryInterceptor()));
        }

        private TaskTimeoutSettings getSettingsForProcessor(String name) {
            return this.properties.getEventProcessor().getOrDefault(name, this.properties.getEventProcessors());
        }
    }
}

