/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.timeout.HandlerTimeoutConfiguration;
import org.axonframework.messaging.timeout.TaskTimeoutSettings;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="axon.timeout")
public class TimeoutProperties {
    private boolean enabled = true;
    private TransactionTimeoutProperties transaction = new TransactionTimeoutProperties();
    private MessageHandlerTimeoutProperties handler = new MessageHandlerTimeoutProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TransactionTimeoutProperties getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionTimeoutProperties properties) {
        this.transaction = properties;
    }

    public MessageHandlerTimeoutProperties getHandler() {
        return this.handler;
    }

    public void setHandler(MessageHandlerTimeoutProperties properties) {
        this.handler = properties;
    }

    public static class TransactionTimeoutProperties {
        @NestedConfigurationProperty
        private TaskTimeoutSettings commandBus = new TaskTimeoutSettings(60000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings queryBus = new TaskTimeoutSettings(60000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings deadline = new TaskTimeoutSettings(60000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings eventProcessors = new TaskTimeoutSettings(60000, 10000, 1000);
        private final Map<String, TaskTimeoutSettings> eventProcessor = new HashMap<String, TaskTimeoutSettings>();

        public TaskTimeoutSettings getCommandBus() {
            return this.commandBus;
        }

        public void setCommandBus(TaskTimeoutSettings commandBus) {
            this.commandBus = commandBus;
        }

        public TaskTimeoutSettings getQueryBus() {
            return this.queryBus;
        }

        public void setQueryBus(TaskTimeoutSettings queryBus) {
            this.queryBus = queryBus;
        }

        public TaskTimeoutSettings getDeadline() {
            return this.deadline;
        }

        public void setDeadline(TaskTimeoutSettings deadline) {
            this.deadline = deadline;
        }

        public TaskTimeoutSettings getEventProcessors() {
            return this.eventProcessors;
        }

        public void setEventProcessors(TaskTimeoutSettings eventProcessors) {
            this.eventProcessors = eventProcessors;
        }

        public Map<String, TaskTimeoutSettings> getEventProcessor() {
            return this.eventProcessor;
        }
    }

    public static class MessageHandlerTimeoutProperties {
        @NestedConfigurationProperty
        private TaskTimeoutSettings events = new TaskTimeoutSettings(30000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings commands = new TaskTimeoutSettings(30000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings queries = new TaskTimeoutSettings(30000, 10000, 1000);
        @NestedConfigurationProperty
        private TaskTimeoutSettings deadlines = new TaskTimeoutSettings(30000, 10000, 1000);

        public TaskTimeoutSettings getEvents() {
            return this.events;
        }

        public void setEvents(TaskTimeoutSettings events) {
            this.events = events;
        }

        public TaskTimeoutSettings getCommands() {
            return this.commands;
        }

        public void setCommands(TaskTimeoutSettings commands) {
            this.commands = commands;
        }

        public TaskTimeoutSettings getQueries() {
            return this.queries;
        }

        public void setQueries(TaskTimeoutSettings queries) {
            this.queries = queries;
        }

        public TaskTimeoutSettings getDeadlines() {
            return this.deadlines;
        }

        public void setDeadlines(TaskTimeoutSettings deadlines) {
            this.deadlines = deadlines;
        }

        public HandlerTimeoutConfiguration toMessageHandlerTimeoutConfiguration() {
            return new HandlerTimeoutConfiguration(this.events, this.commands, this.queries, this.deadlines);
        }
    }
}

