/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.Configuration;
import org.axonframework.extension.spring.config.SpringAxonApplication;
import org.axonframework.extension.spring.config.SpringComponentRegistry;
import org.axonframework.extension.spring.config.SpringLifecycleRegistry;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class AxonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    SpringComponentRegistry springComponentRegistry(ApplicationContext applicationContext, SpringLifecycleRegistry springLifecycleRegistry) {
        return new SpringComponentRegistry((ListableBeanFactory)applicationContext, springLifecycleRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.ALL)
    SpringLifecycleRegistry springLifecycleRegistry() {
        return new SpringLifecycleRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.ALL)
    SpringAxonApplication axonApplication(SpringComponentRegistry springComponentRegistry, SpringLifecycleRegistry springLifecycleRegistry) {
        return new SpringAxonApplication(springComponentRegistry, springLifecycleRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={SpringAxonApplication.class}, search=SearchStrategy.CURRENT)
    AxonConfiguration axonApplicationConfiguration(SpringAxonApplication axonApplication) {
        return axonApplication.build();
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    @ConditionalOnBean(value={AxonConfiguration.class}, search=SearchStrategy.ALL)
    Configuration axonConfiguration(SpringComponentRegistry springComponentRegistry) {
        return springComponentRegistry.configuration();
    }
}

