/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import java.util.function.Function;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.monitoring.MessageMonitor;

public class MessageCountingMonitor
implements MessageMonitor<Message> {
    private static final String INGESTED_COUNTER = ".ingestedCounter";
    private static final String SUCCESS_COUNTER = ".successCounter";
    private static final String FAILURE_COUNTER = ".failureCounter";
    private static final String PROCESSED_COUNTER = ".processedCounter";
    private static final String IGNORED_COUNTER = ".ignoredCounter";
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Function<Message, Iterable<Tag>> tagsBuilder;

    private MessageCountingMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        this(meterNamePrefix, meterRegistry, message -> Tags.empty());
    }

    private MessageCountingMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message, Iterable<Tag>> tagsBuilder) {
        this.meterNamePrefix = meterNamePrefix;
        this.meterRegistry = meterRegistry;
        this.tagsBuilder = tagsBuilder;
    }

    public static MessageCountingMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return new MessageCountingMonitor(meterNamePrefix, meterRegistry);
    }

    public static MessageCountingMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message, Iterable<Tag>> tagsBuilder) {
        return new MessageCountingMonitor(meterNamePrefix, meterRegistry, tagsBuilder);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(@Nonnull Message message) {
        Iterable<Tag> tags = this.tagsBuilder.apply(message);
        Counter ingestedCounter = this.meterRegistry.counter(this.meterNamePrefix + INGESTED_COUNTER, tags);
        final Counter successCounter = this.meterRegistry.counter(this.meterNamePrefix + SUCCESS_COUNTER, tags);
        final Counter failureCounter = this.meterRegistry.counter(this.meterNamePrefix + FAILURE_COUNTER, tags);
        final Counter processedCounter = this.meterRegistry.counter(this.meterNamePrefix + PROCESSED_COUNTER, tags);
        final Counter ignoredCounter = this.meterRegistry.counter(this.meterNamePrefix + IGNORED_COUNTER, tags);
        ingestedCounter.increment();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                processedCounter.increment();
                successCounter.increment();
            }

            public void reportFailure(Throwable cause) {
                processedCounter.increment();
                failureCounter.increment();
            }

            public void reportIgnored() {
                ignoredCounter.increment();
            }
        };
    }
}

