/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.metrics.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.EventProcessor;
import org.axonframework.extension.metrics.micrometer.CapacityMonitor;
import org.axonframework.extension.metrics.micrometer.EventProcessorLatencyMonitor;
import org.axonframework.extension.metrics.micrometer.MessageCountingMonitor;
import org.axonframework.extension.metrics.micrometer.MessageTimerMonitor;
import org.axonframework.extension.metrics.micrometer.TagsUtil;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMetricRegistry {
    private static final Logger logger = LoggerFactory.getLogger(GlobalMetricRegistry.class);
    private static final String EVENT_PROCESSOR_METRICS_NAME = "eventProcessor";
    private final MeterRegistry registry;

    public GlobalMetricRegistry() {
        this((MeterRegistry)new SimpleMeterRegistry());
    }

    public GlobalMetricRegistry(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }

    public MessageMonitor<? extends Message> registerComponent(Class<?> componentType, String componentName) {
        if (EventProcessor.class.isAssignableFrom(componentType)) {
            return this.registerEventProcessor(componentName);
        }
        if (CommandBus.class.isAssignableFrom(componentType)) {
            return this.registerCommandBus(componentName);
        }
        if (EventBus.class.isAssignableFrom(componentType)) {
            return this.registerEventBus(componentName);
        }
        if (QueryBus.class.isAssignableFrom(componentType)) {
            return this.registerQueryBus(componentName);
        }
        if (QueryUpdateEmitter.class.isAssignableFrom(componentType)) {
            return this.registerQueryUpdateEmitter(componentName);
        }
        logger.warn("Cannot provide MessageMonitor for component [{}] of type [{}]. Returning No-Op instance.", (Object)componentName, (Object)componentType.getSimpleName());
        return NoOpMessageMonitor.instance();
    }

    public MessageMonitor<? super EventMessage> registerEventProcessor(String eventProcessorName) {
        ArrayList<Object> monitors = new ArrayList<Object>();
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(eventProcessorName).meterRegistry(this.registry).build();
        monitors.add(messageTimerMonitor);
        monitors.add(EventProcessorLatencyMonitor.builder().meterNamePrefix(eventProcessorName).meterRegistry(this.registry).build());
        monitors.add(CapacityMonitor.buildMonitor(eventProcessorName, this.registry));
        monitors.add(MessageCountingMonitor.buildMonitor(eventProcessorName, this.registry));
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<? super CommandMessage> registerCommandBus(String commandBusName) {
        return this.registerDefaultHandlerMessageMonitor(commandBusName);
    }

    public MessageMonitor<? super EventMessage> registerEventBus(String eventBusName) {
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(eventBusName, this.registry);
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(eventBusName).meterRegistry(this.registry).build();
        return new MultiMessageMonitor(Arrays.asList(messageCountingMonitor, messageTimerMonitor));
    }

    public MessageMonitor<? super QueryMessage> registerQueryBus(String queryBusName) {
        return this.registerDefaultHandlerMessageMonitor(queryBusName);
    }

    private MessageMonitor<? extends Message> registerQueryUpdateEmitter(String updateEmitterName) {
        return this.registerDefaultHandlerMessageMonitor(updateEmitterName);
    }

    public MessageMonitor<? extends Message> registerComponentWithDefaultTags(Class<?> componentType, String componentName) {
        if (EventProcessor.class.isAssignableFrom(componentType)) {
            return this.registerEventProcessor(EVENT_PROCESSOR_METRICS_NAME, message -> Tags.of((String[])new String[]{"payloadType", message.payloadType().getSimpleName(), "processorName", componentName}), message -> Tags.of((String)"processorName", (String)componentName));
        }
        if (CommandBus.class.isAssignableFrom(componentType)) {
            return this.registerCommandBus(componentName, TagsUtil.PAYLOAD_TYPE_TAGGER_FUNCTION);
        }
        if (EventBus.class.isAssignableFrom(componentType)) {
            return this.registerEventBus(componentName, TagsUtil.PAYLOAD_TYPE_TAGGER_FUNCTION);
        }
        if (QueryBus.class.isAssignableFrom(componentType)) {
            return this.registerQueryBus(componentName, TagsUtil.PAYLOAD_TYPE_TAGGER_FUNCTION);
        }
        if (QueryUpdateEmitter.class.isAssignableFrom(componentType)) {
            return this.registerQueryUpdateEmitter(componentName, TagsUtil.PAYLOAD_TYPE_TAGGER_FUNCTION);
        }
        logger.warn("Cannot provide MessageMonitor for component [{}] of type [{}]. Returning No-Op instance.", (Object)componentName, (Object)componentType.getSimpleName());
        return NoOpMessageMonitor.instance();
    }

    public MessageMonitor<? super EventMessage> registerEventProcessor(String eventProcessorName, Function<Message, Iterable<Tag>> tagsBuilder, Function<Message, Iterable<Tag>> latencyTagsBuilder) {
        ArrayList<Object> monitors = new ArrayList<Object>();
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(eventProcessorName).meterRegistry(this.registry).tagsBuilder(tagsBuilder).build();
        monitors.add(messageTimerMonitor);
        monitors.add(EventProcessorLatencyMonitor.builder().meterNamePrefix(eventProcessorName).meterRegistry(this.registry).tagsBuilder(latencyTagsBuilder).build());
        monitors.add(CapacityMonitor.buildMonitor(eventProcessorName, this.registry, tagsBuilder));
        monitors.add(MessageCountingMonitor.buildMonitor(eventProcessorName, this.registry, tagsBuilder));
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<? super CommandMessage> registerCommandBus(String commandBusName, Function<Message, Iterable<Tag>> tagsBuilder) {
        return this.registerDefaultHandlerMessageMonitor(commandBusName, tagsBuilder);
    }

    public MessageMonitor<? super EventMessage> registerEventBus(String eventBusName, Function<Message, Iterable<Tag>> tagsBuilder) {
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(eventBusName, this.registry);
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(eventBusName).meterRegistry(this.registry).tagsBuilder(tagsBuilder).build();
        return new MultiMessageMonitor(Arrays.asList(messageCountingMonitor, messageTimerMonitor));
    }

    public MessageMonitor<? super QueryMessage> registerQueryBus(String queryBusName, Function<Message, Iterable<Tag>> tagsBuilder) {
        return this.registerDefaultHandlerMessageMonitor(queryBusName, tagsBuilder);
    }

    private MessageMonitor<? extends Message> registerQueryUpdateEmitter(String updateEmitterName, Function<Message, Iterable<Tag>> tagsBuilder) {
        return this.registerDefaultHandlerMessageMonitor(updateEmitterName, tagsBuilder);
    }

    private MessageMonitor<Message> registerDefaultHandlerMessageMonitor(String name) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(name).meterRegistry(this.registry).build();
        CapacityMonitor capacityMonitor = CapacityMonitor.buildMonitor(name, this.registry);
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(name, this.registry);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    private MessageMonitor<Message> registerDefaultHandlerMessageMonitor(String name, Function<Message, Iterable<Tag>> tagsBuilder) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().meterNamePrefix(name).meterRegistry(this.registry).tagsBuilder(tagsBuilder).build();
        CapacityMonitor capacityMonitor = CapacityMonitor.buildMonitor(name, this.registry, tagsBuilder);
        MessageCountingMonitor messageCountingMonitor = MessageCountingMonitor.buildMonitor(name, this.registry, tagsBuilder);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }
}

