/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.metrics.dropwizard;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.Snapshot;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.monitoring.MessageMonitor;

public class CapacityMonitor
implements MessageMonitor<Message>,
MetricSet {
    private final Histogram processedDurationHistogram;
    private final TimeUnit timeUnit;
    private final long window;
    private final Clock clock;
    private final Metric capacity;

    public CapacityMonitor() {
        this(10L, TimeUnit.MINUTES);
    }

    public CapacityMonitor(long window, TimeUnit timeUnit) {
        this(window, timeUnit, Clock.defaultClock());
    }

    public CapacityMonitor(long window, TimeUnit timeUnit, Clock clock) {
        SlidingTimeWindowReservoir slidingTimeWindowReservoir = new SlidingTimeWindowReservoir(window, timeUnit, clock);
        this.processedDurationHistogram = new Histogram((Reservoir)slidingTimeWindowReservoir);
        this.timeUnit = timeUnit;
        this.window = window;
        this.clock = clock;
        this.capacity = new CapacityGauge();
    }

    public MessageMonitor.MonitorCallback onMessageIngested(@Nonnull Message message) {
        final long start = this.clock.getTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                CapacityMonitor.this.processedDurationHistogram.update(CapacityMonitor.this.clock.getTime() - start);
            }

            public void reportFailure(Throwable cause) {
                CapacityMonitor.this.processedDurationHistogram.update(CapacityMonitor.this.clock.getTime() - start);
            }

            public void reportIgnored() {
                CapacityMonitor.this.processedDurationHistogram.update(CapacityMonitor.this.clock.getTime() - start);
            }
        };
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("capacity", this.capacity);
        return metrics;
    }

    private class CapacityGauge
    implements Gauge<Double> {
        private CapacityGauge() {
        }

        public Double getValue() {
            Snapshot snapshot = CapacityMonitor.this.processedDurationHistogram.getSnapshot();
            double meanProcessTime = snapshot.getMean();
            int numProcessed = snapshot.getValues().length;
            return (double)numProcessed * meanProcessTime / (double)CapacityMonitor.this.timeUnit.toMillis(CapacityMonitor.this.window);
        }
    }
}

