/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage>,
MetricSet {
    private final Clock clock;
    private final AtomicLong processTime = new AtomicLong();

    public EventProcessorLatencyMonitor() {
        this(Clock.systemUTC());
    }

    public EventProcessorLatencyMonitor(Clock clock) {
        this.clock = clock;
    }

    public MessageMonitor.MonitorCallback onMessageIngested(@Nonnull EventMessage message) {
        if (message != null) {
            this.processTime.set(Duration.between(message.timestamp(), this.clock.instant()).toMillis());
        }
        return NoOpMessageMonitorCallback.INSTANCE;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("latency", (Metric)((Gauge)this.processTime::get));
        return metrics;
    }
}

