/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.EventProcessor;
import org.axonframework.extension.metrics.dropwizard.CapacityMonitor;
import org.axonframework.extension.metrics.dropwizard.EventProcessorLatencyMonitor;
import org.axonframework.extension.metrics.dropwizard.MessageCountingMonitor;
import org.axonframework.extension.metrics.dropwizard.MessageTimerMonitor;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMetricRegistry {
    private static final Logger logger = LoggerFactory.getLogger(GlobalMetricRegistry.class);
    private final MetricRegistry registry;

    public GlobalMetricRegistry() {
        this(new MetricRegistry());
    }

    public GlobalMetricRegistry(MetricRegistry metricRegistry) {
        this.registry = metricRegistry;
    }

    public MessageMonitor<? extends Message> registerComponent(Class<?> componentType, String componentName) {
        if (EventProcessor.class.isAssignableFrom(componentType)) {
            return this.registerEventProcessor(componentName);
        }
        if (CommandBus.class.isAssignableFrom(componentType)) {
            return this.registerCommandBus(componentName);
        }
        if (EventBus.class.isAssignableFrom(componentType)) {
            return this.registerEventBus(componentName);
        }
        if (QueryBus.class.isAssignableFrom(componentType)) {
            return this.registerQueryBus(componentName);
        }
        if (QueryUpdateEmitter.class.isAssignableFrom(componentType)) {
            return this.registerQueryUpdateEmitter(componentName);
        }
        logger.warn("Cannot provide MessageMonitor for component [{}] of type [{}]. Returning No-Op instance.", (Object)componentName, (Object)componentType.getSimpleName());
        return NoOpMessageMonitor.instance();
    }

    public MessageMonitor<? super EventMessage> registerEventProcessor(String eventProcessorName) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().build();
        EventProcessorLatencyMonitor eventProcessorLatencyMonitor = new EventProcessorLatencyMonitor();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        eventProcessingRegistry.register("latency", (Metric)eventProcessorLatencyMonitor);
        eventProcessingRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        eventProcessingRegistry.register("capacity", (Metric)capacityMonitor);
        this.registry.register(eventProcessorName, (Metric)eventProcessingRegistry);
        ArrayList<Object> monitors = new ArrayList<Object>();
        monitors.add(messageTimerMonitor);
        monitors.add(eventProcessorLatencyMonitor);
        monitors.add(capacityMonitor);
        monitors.add(messageCountingMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<? super CommandMessage> registerCommandBus(String commandBusName) {
        return this.registerDefaultHandlerMessageMonitor(commandBusName);
    }

    public MessageMonitor<? super EventMessage> registerEventBus(String eventBusName) {
        MessageCountingMonitor messageCounterMonitor = new MessageCountingMonitor();
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().build();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageCounter", (Metric)messageCounterMonitor);
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        this.registry.register(eventBusName, (Metric)eventProcessingRegistry);
        return new MultiMessageMonitor(Arrays.asList(messageCounterMonitor, messageTimerMonitor));
    }

    public MessageMonitor<? super QueryMessage> registerQueryBus(String queryBusName) {
        return this.registerDefaultHandlerMessageMonitor(queryBusName);
    }

    private MessageMonitor<? extends Message> registerQueryUpdateEmitter(String updateEmitterName) {
        return this.registerDefaultHandlerMessageMonitor(updateEmitterName);
    }

    private MessageMonitor<Message> registerDefaultHandlerMessageMonitor(String name) {
        MessageTimerMonitor messageTimerMonitor = MessageTimerMonitor.builder().build();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry handlerRegistry = new MetricRegistry();
        handlerRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        handlerRegistry.register("capacity", (Metric)capacityMonitor);
        handlerRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        this.registry.register(name, (Metric)handlerRegistry);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }
}

