/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.update.detection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.axonframework.common.annotation.Internal;
import org.axonframework.update.api.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class AxonVersionDetector {
    private static final Logger logger = LoggerFactory.getLogger(AxonVersionDetector.class);
    private static final List<String> GROUP_IDS = List.of("org/axonframework", "io/axoniq");

    private AxonVersionDetector() {
    }

    public static List<Artifact> safeDetectAxonModules() {
        try {
            return AxonVersionDetector.detectAxonModules().stream().distinct().toList();
        }
        catch (Exception e) {
            logger.error("Failed to detect Axon Framework modules", (Throwable)e);
            return List.of();
        }
    }

    private static List<Artifact> detectAxonModules() {
        LinkedList<Artifact> foundVersions = new LinkedList<Artifact>();
        LinkedList<URL> urlsToCheck = new LinkedList<URL>();
        for (String groupId : GROUP_IDS) {
            try {
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/maven/");
                while (resources.hasMoreElements()) {
                    urlsToCheck.add(resources.nextElement());
                }
            }
            catch (IOException e) {
                logger.debug("Failed to retrieve Axon Framework modules for group ID: {}", (Object)groupId, (Object)e);
            }
        }
        for (URL url : urlsToCheck) {
            try {
                String filePath = url.getFile();
                if (GROUP_IDS.stream().noneMatch(filePath::contains) && !filePath.contains("test-classes")) continue;
                if (url.getProtocol().equals("jar")) {
                    foundVersions.addAll(AxonVersionDetector.extractVersionFromJar(url));
                    continue;
                }
                if (!url.getProtocol().equals("file")) continue;
                foundVersions.addAll(AxonVersionDetector.extractVersionFromDirectory(url));
            }
            catch (Exception e) {
                logger.debug("Failed to read Axon Framework module at URL: {}", (Object)url, (Object)e);
            }
        }
        return foundVersions;
    }

    private static List<Artifact> extractVersionFromJar(URL url) throws IOException {
        String jarFilePath = url.getPath().substring(5, url.getPath().indexOf("!"));
        try (JarFile jarFile = new JarFile(new File(jarFilePath));){
            List<Artifact> list = jarFile.stream().filter(entry -> entry.getName().startsWith("META-INF/maven/")).filter(entry -> entry.getName().endsWith("/pom.properties")).map(entry -> {
                Artifact artifact;
                block8: {
                    InputStream inputStream = jarFile.getInputStream((ZipEntry)entry);
                    try {
                        artifact = AxonVersionDetector.mapToAxonVersion(inputStream);
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            logger.debug("Failed to read pom.properties from JAR entry: {}", (Object)entry.getName(), (Object)e);
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return artifact;
            }).toList();
            return list;
        }
    }

    private static Artifact mapToAxonVersion(InputStream inputStream) throws IOException {
        Properties mavenProps = new Properties();
        mavenProps.load(inputStream);
        return new Artifact(mavenProps.getProperty("groupId"), mavenProps.getProperty("artifactId"), mavenProps.getProperty("version"));
    }

    private static List<Artifact> extractVersionFromDirectory(URL url) throws URISyntaxException {
        File file = new File(url.toURI());
        LinkedList<Artifact> foundVersions = new LinkedList<Artifact>();
        if (file.isDirectory()) {
            List<File> filesToCheck = AxonVersionDetector.scanDirectoryForPomProperties(file);
            for (File pomFile : filesToCheck) {
                try {
                    Artifact version = AxonVersionDetector.mapToAxonVersion(Files.newInputStream(pomFile.toPath(), new OpenOption[0]));
                    foundVersions.add(version);
                }
                catch (Exception e) {
                    logger.debug("Unexpected error while processing pom.properties file: {}", (Object)pomFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return foundVersions;
    }

    private static List<File> scanDirectoryForPomProperties(File dir) {
        LinkedList<File> files = new LinkedList<File>();
        AxonVersionDetector.scanRecursivelyForPomProperties(dir, files);
        return files;
    }

    private static void scanRecursivelyForPomProperties(File dir, List<File> files) {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                AxonVersionDetector.scanRecursivelyForPomProperties(child, files);
                continue;
            }
            if (!child.getName().equals("pom.properties")) continue;
            files.add(child);
        }
    }
}

