/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.update;

import jakarta.annotation.Nonnull;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.update.LoggingUpdateCheckerReporter;
import org.axonframework.update.UpdateChecker;
import org.axonframework.update.UpdateCheckerHttpClient;
import org.axonframework.update.UpdateCheckerReporter;
import org.axonframework.update.configuration.UsagePropertyProvider;
import org.axonframework.update.detection.TestEnvironmentDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class UpdateCheckerConfigurationEnhancer
implements ConfigurationEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerConfigurationEnhancer.class);
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;

    public void enhance(@Nonnull ComponentRegistry componentRegistry) {
        if (TestEnvironmentDetector.isTestEnvironment()) {
            logger.debug("Skipping AxonIQ UpdateChecker as a testsuite environment was detected.");
            return;
        }
        componentRegistry.registerIfNotPresent(ComponentDefinition.ofType(UsagePropertyProvider.class).withBuilder(c -> UsagePropertyProvider.create(new UsagePropertyProvider[0]))).registerIfNotPresent(ComponentDefinition.ofType(UpdateCheckerHttpClient.class).withBuilder(c -> {
            UsagePropertyProvider propertyProvider = (UsagePropertyProvider)c.getComponent(UsagePropertyProvider.class);
            return new UpdateCheckerHttpClient(propertyProvider);
        })).registerIfNotPresent(ComponentDefinition.ofType(UpdateCheckerReporter.class).withBuilder(c -> new LoggingUpdateCheckerReporter())).registerIfNotPresent(ComponentDefinition.ofType(UpdateChecker.class).withBuilder(c -> new UpdateChecker((UpdateCheckerHttpClient)c.getComponent(UpdateCheckerHttpClient.class), (UpdateCheckerReporter)c.getComponent(UpdateCheckerReporter.class), (UsagePropertyProvider)c.getComponent(UsagePropertyProvider.class))).onStart(-134217728, UpdateChecker::start).onShutdown(-134217728, UpdateChecker::stop));
    }

    public int order() {
        return Integer.MAX_VALUE;
    }
}

