/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.update;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.annotation.Internal;
import org.axonframework.update.UpdateCheckerHttpClient;
import org.axonframework.update.UpdateCheckerReporter;
import org.axonframework.update.api.UpdateCheckRequest;
import org.axonframework.update.api.UpdateCheckResponse;
import org.axonframework.update.common.DelayedTask;
import org.axonframework.update.configuration.UsagePropertyProvider;
import org.axonframework.update.detection.AxonVersionDetector;
import org.axonframework.update.detection.KotlinVersion;
import org.axonframework.update.detection.MachineId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class UpdateChecker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateChecker.class);
    private final UpdateCheckerHttpClient client;
    private final MachineId machineId;
    private final UpdateCheckerReporter reporter;
    private boolean firstRequest = true;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private int errorRetryBackoffFactor = 1;
    private DelayedTask delayedTask;

    public UpdateChecker(@Nonnull UpdateCheckerHttpClient client, @Nonnull UpdateCheckerReporter reporter) {
        this.client = Objects.requireNonNull(client, "The client must not be null.");
        this.machineId = new MachineId();
        this.reporter = Objects.requireNonNull(reporter, "The reporter must not be null.");
    }

    public void start() {
        try {
            if (!this.started.compareAndSet(false, true)) {
                logger.debug("The AxonIQ UpdateChecker was already started.");
                return;
            }
            UsagePropertyProvider userProperties = UsagePropertyProvider.create();
            if (userProperties.getDisabled().booleanValue()) {
                logger.info("You have opted out of the AxonIQ UpdateChecker. No update or vulnerabilities will be checked. See https://www.axoniq.io/update-check for more information.");
                return;
            }
            logger.info("Your AxonIQ libraries will be checked for update periodically. See https://www.axoniq.io/update-check for more information.");
            this.delayedTask = DelayedTask.of(this, 1000L);
        }
        catch (Exception e) {
            logger.warn("Failed to start the UpdateChecker task.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (!this.started.get()) {
            return;
        }
        try {
            UpdateCheckRequest requestBody = this.buildRequest();
            Optional<UpdateCheckResponse> response = this.client.sendRequest(requestBody, this.firstRequest);
            if (response.isEmpty()) {
                this.scheduleErrorRetry();
                return;
            }
            UpdateCheckResponse updateCheckResponse = response.get();
            this.reporter.report(requestBody, updateCheckResponse);
            logger.debug("AxonIQ will check library update and vulnerabilities again in {} seconds.", (Object)updateCheckResponse);
            this.delayedTask = DelayedTask.of(this, (long)updateCheckResponse.checkInterval() * 1000L);
            this.errorRetryBackoffFactor = 1;
            this.firstRequest = false;
        }
        catch (Exception e) {
            logger.warn("The AxonIQ UpdateChecker failed to fetch update and vulnerabilities.", (Throwable)e);
            this.scheduleErrorRetry();
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            logger.info("Stopped the AxonIQ UpdateChecker. No further update will be checked.");
            if (this.delayedTask != null) {
                this.delayedTask.cancel();
                this.delayedTask = null;
            }
        }
    }

    private void scheduleErrorRetry() {
        ++this.errorRetryBackoffFactor;
        int nextInvocationTime = Math.min((int)(Math.pow(2.0, this.errorRetryBackoffFactor) * 1000.0), 60000);
        this.delayedTask = DelayedTask.of(this, nextInvocationTime);
    }

    @Nonnull
    private UpdateCheckRequest buildRequest() {
        String jvmVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        String installationId = UUID.randomUUID().toString();
        return new UpdateCheckRequest(this.machineId.get(), installationId, osName, osVersion, osArch, javaVersion, jvmVendor, KotlinVersion.get(), AxonVersionDetector.safeDetectAxonModules());
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

