/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing.opentelemetry;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetrySpan
implements Span {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySpan.class);
    private final SpanBuilder spanBuilder;
    private final List<Scope> scopes = new CopyOnWriteArrayList<Scope>();
    private io.opentelemetry.api.trace.Span span = null;
    private boolean ended = false;

    public OpenTelemetrySpan(SpanBuilder spanBuilder) {
        Objects.requireNonNull(spanBuilder, "Span builder can not be null!");
        this.spanBuilder = spanBuilder;
    }

    public Span start() {
        if (this.span == null) {
            this.span = this.spanBuilder.startSpan();
        } else {
            logger.error("An attempt was made to start span with id [{}] of trace [{}] a second time", (Object)this.span.getSpanContext().getSpanId(), (Object)this.span.getSpanContext().getTraceId());
        }
        return this;
    }

    public SpanScope makeCurrent() {
        if (this.span == null) {
            logger.error("Span was attempted to be made current while not started yet! Please report this to the Axon Framework team.", (Throwable)new IllegalStateException("Span attempted to be made current while not started"));
            return () -> {};
        }
        Scope scope = this.span.makeCurrent();
        this.scopes.add(scope);
        return () -> {
            this.scopes.remove(scope);
            scope.close();
        };
    }

    public void end() {
        if (this.span == null) {
            logger.error("Span was attempted to be ended while not started yet! Please report this to the Axon Framework team.", (Throwable)new IllegalStateException("Span attempted to be ended while not started"));
            return;
        }
        if (this.ended) {
            logger.error("Span ended a second time! Will ignore this ended invocation. Please report this to the Axon Framework team.", (Throwable)new IllegalStateException("Span ended a second time"));
            return;
        }
        if (!this.scopes.isEmpty()) {
            logger.error("Span ended without all scopes! Please report this to the Axon Framework team. This might influence reliability of your OpenTelemetry traces.", (Throwable)new IllegalStateException("Span ended with still " + this.scopes.size() + " open!"));
        }
        this.span.end();
        this.ended = true;
    }

    public Span recordException(Throwable t) {
        this.span.recordException(t);
        this.span.setStatus(StatusCode.ERROR, t.getMessage());
        return this;
    }
}

