/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanUtils;
import org.axonframework.tracing.opentelemetry.MetadataContextGetter;
import org.axonframework.tracing.opentelemetry.MetadataContextSetter;
import org.axonframework.tracing.opentelemetry.OpenTelemetrySpan;

public class OpenTelemetrySpanFactory
implements SpanFactory {
    private final Tracer tracer;
    private final List<SpanAttributesProvider> spanAttributesProviders;
    private final TextMapGetter<Message<?>> textMapGetter;
    private final TextMapSetter<Map<String, String>> textMapSetter;

    public OpenTelemetrySpanFactory(Builder builder) {
        this.spanAttributesProviders = builder.spanAttributesProviders;
        this.tracer = builder.tracer;
        this.textMapGetter = builder.textMapGetter;
        this.textMapSetter = builder.textMapSetter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <M extends Message<?>> M propagateContext(M message) {
        HashMap additionalMetadataProperties = new HashMap();
        this.propagator().inject(Context.current(), additionalMetadataProperties, this.textMapSetter);
        return (M)message.andMetaData(additionalMetadataProperties);
    }

    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operationNameSupplier.get()).setSpanKind(SpanKind.INTERNAL);
        spanBuilder.addLink(io.opentelemetry.api.trace.Span.current().getSpanContext()).setNoParent();
        return new OpenTelemetrySpan(spanBuilder);
    }

    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        Context parentContext = this.propagator().extract(Context.current(), parentMessage, this.textMapGetter);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.formatName(operationNameSupplier.get(), parentMessage)).setSpanKind(SpanKind.CONSUMER);
        if (isChildTrace) {
            spanBuilder.setParent(parentContext);
        } else {
            spanBuilder.addLink(io.opentelemetry.api.trace.Span.fromContext((Context)parentContext).getSpanContext()).setNoParent();
        }
        this.addLinks(spanBuilder, linkedParents);
        this.addMessageAttributes(spanBuilder, parentMessage);
        return new OpenTelemetrySpan(spanBuilder);
    }

    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.formatName(operationNameSupplier.get(), parentMessage)).setSpanKind(SpanKind.PRODUCER);
        this.addLinks(spanBuilder, linkedSiblings);
        this.addMessageAttributes(spanBuilder, parentMessage);
        return new OpenTelemetrySpan(spanBuilder);
    }

    private void addLinks(SpanBuilder spanBuilder, Message<?>[] linkedMessages) {
        for (Message<?> message : linkedMessages) {
            Context linkedContext = this.propagator().extract(Context.current(), message, this.textMapGetter);
            spanBuilder.addLink(io.opentelemetry.api.trace.Span.fromContext((Context)linkedContext).getSpanContext());
        }
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operationNameSupplier.get()).setSpanKind(SpanKind.INTERNAL);
        return new OpenTelemetrySpan(spanBuilder);
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.formatName(operationNameSupplier.get(), message)).setSpanKind(SpanKind.INTERNAL);
        this.addMessageAttributes(spanBuilder, message);
        return new OpenTelemetrySpan(spanBuilder);
    }

    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
        this.spanAttributesProviders.add(provider);
    }

    private String formatName(String operationName, Message<?> message) {
        if (message == null) {
            return operationName;
        }
        return String.format("%s(%s)", operationName, SpanUtils.determineMessageName(message));
    }

    private void addMessageAttributes(SpanBuilder spanBuilder, Message<?> message) {
        if (message == null) {
            return;
        }
        this.spanAttributesProviders.forEach(supplier -> {
            Map attributes = supplier.provideForMessage(message);
            attributes.forEach((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1));
        });
    }

    private TextMapPropagator propagator() {
        return GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    }

    public static class Builder {
        private Tracer tracer = null;
        private TextMapSetter<Map<String, String>> textMapSetter = MetadataContextSetter.INSTANCE;
        private TextMapGetter<Message<?>> textMapGetter = MetadataContextGetter.INSTANCE;
        private final List<SpanAttributesProvider> spanAttributesProviders = new LinkedList<SpanAttributesProvider>();

        public Builder addSpanAttributeProviders(@Nonnull List<SpanAttributesProvider> attributesProviders) {
            BuilderUtils.assertNonNull(attributesProviders, (String)"The attributesProviders should not be null");
            this.spanAttributesProviders.addAll(attributesProviders);
            return this;
        }

        public Builder tracer(@Nonnull Tracer tracer) {
            BuilderUtils.assertNonNull((Object)tracer, (String)"The Tracer should not be null");
            this.tracer = tracer;
            return this;
        }

        public Builder textMapSetter(TextMapSetter<Map<String, String>> textMapSetter) {
            BuilderUtils.assertNonNull(textMapSetter, (String)"The TextMapSetter should not be null");
            this.textMapSetter = textMapSetter;
            return this;
        }

        public Builder textMapGetter(TextMapGetter<Message<?>> textMapGetter) {
            BuilderUtils.assertNonNull(textMapGetter, (String)"The TextMapGetter should not be null");
            this.textMapGetter = textMapGetter;
            return this;
        }

        public OpenTelemetrySpanFactory build() {
            if (this.tracer == null) {
                this.tracer = GlobalOpenTelemetry.getTracer((String)"AxonFramework-OpenTelemetry");
            }
            return new OpenTelemetrySpanFactory(this);
        }
    }
}

