/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.unitofwork.ProcessingContext;

class RecordingEventSink
implements EventSink {
    protected final EventSink delegate;
    private final List<EventMessage<?>> recorded;

    RecordingEventSink(EventSink delegate) {
        this.delegate = delegate;
        this.recorded = new ArrayList();
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage<?>> events) {
        return this.delegate.publish(context, events).thenRun(() -> this.recorded.addAll(events));
    }

    public List<EventMessage<?>> recorded() {
        return List.copyOf(this.recorded);
    }

    public RecordingEventSink reset() {
        this.recorded.clear();
        return this;
    }
}

