/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.aggregate.Reporter;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;
import org.axonframework.test.matchers.MapStringEntryMatcher;
import org.axonframework.test.matchers.MatchAllFieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.CommandValidator;
import org.hamcrest.Matcher;

abstract class AxonTestThenMessage<T extends AxonTestPhase.Then.Message<T>>
implements AxonTestPhase.Then.Message<T> {
    protected final Reporter reporter = new Reporter();
    private final Configuration configuration;
    private final AxonTestFixture.Customization customization;
    private final RecordingEventSink eventSink;
    private final RecordingCommandBus commandBus;
    private final CommandValidator commandValidator;
    protected final Throwable actualException;

    public AxonTestThenMessage(Configuration configuration, AxonTestFixture.Customization customization, RecordingCommandBus commandBus, RecordingEventSink eventSink, Throwable actualException) {
        this.configuration = configuration;
        this.customization = customization;
        this.commandBus = commandBus;
        this.eventSink = eventSink;
        this.actualException = actualException;
        this.commandValidator = new CommandValidator(commandBus::recordedCommands, commandBus::reset, new MatchAllFieldFilter(customization.fieldFilters()));
    }

    @Override
    public T events(Object ... expectedEvents) {
        List<EventMessage<?>> publishedEvents = this.eventSink.recorded();
        if (expectedEvents.length != publishedEvents.size()) {
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage<?>> iterator = publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyPayloadEquality(expectedEvent, actualEvent.getPayload())) continue;
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this.self();
    }

    @Override
    public T events(EventMessage<?> ... expectedEvents) {
        this.events(Stream.of(expectedEvents).map(Message::getPayload).toArray());
        List<EventMessage<?>> publishedEvents = this.eventSink.recorded();
        Iterator<EventMessage<?>> iterator = publishedEvents.iterator();
        for (EventMessage<?> expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyMetaDataEquality(expectedEvent.getPayloadType(), (Map<String, String>)expectedEvent.getMetaData(), (Map<String, String>)actualEvent.getMetaData())) continue;
            this.reporter.reportWrongEvent(publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this.self();
    }

    @Override
    public T eventsSatisfy(@Nonnull Consumer<List<EventMessage<?>>> consumer) {
        List<EventMessage<?>> publishedEvents = this.eventSink.recorded();
        try {
            consumer.accept(publishedEvents);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Events does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T eventsMatch(@Nonnull Predicate<List<EventMessage<?>>> predicate) {
        List<EventMessage<?>> publishedEvents = this.eventSink.recorded();
        boolean result = predicate.test(publishedEvents);
        if (!result) {
            throw new AxonAssertionError("Events does not satisfy the predicate");
        }
        return this.self();
    }

    @Override
    public T commands(Object ... expectedCommands) {
        this.commandValidator.assertDispatchedEqualTo(expectedCommands);
        return this.self();
    }

    @Override
    public T commands(CommandMessage<?> ... expectedCommands) {
        this.commandValidator.assertDispatchedEqualTo(List.of(expectedCommands));
        return this.self();
    }

    @Override
    public T commandsSatisfy(@Nonnull Consumer<List<CommandMessage<?>>> consumer) {
        List<CommandMessage<?>> dispatchedCommands = this.commandBus.recordedCommands();
        try {
            consumer.accept(dispatchedCommands);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Commands does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T commandsMatch(@Nonnull Predicate<List<CommandMessage<?>>> predicate) {
        List<CommandMessage<?>> dispatchedCommands = this.commandBus.recordedCommands();
        boolean result = predicate.test(dispatchedCommands);
        if (!result) {
            throw new AxonAssertionError("Events does not satisfy the predicate");
        }
        return this.self();
    }

    @Override
    public T noCommands() {
        this.commandValidator.assertDispatchedMatching(Matchers.noCommands());
        return this.self();
    }

    @Override
    public T exceptionSatisfies(@Nonnull Consumer<Throwable> consumer) {
        try {
            consumer.accept(this.actualException);
        }
        catch (AssertionError e) {
            throw new AxonAssertionError("Exception does not satisfy custom assertions", (Throwable)((Object)e));
        }
        return this.self();
    }

    @Override
    public T exception(@Nonnull Class<? extends Throwable> type, @Nonnull String message) {
        if (this.actualException == null) {
            throw new AxonAssertionError("Expected exception of type " + String.valueOf(type) + " with message '" + message + "' but got none");
        }
        if (!type.isInstance(this.actualException) || !message.equals(this.actualException.getMessage())) {
            throw new AxonAssertionError("Expected " + String.valueOf(type) + " with message '" + message + "' but got " + String.valueOf(this.actualException));
        }
        return this.self();
    }

    @Override
    public T exception(@Nonnull Class<? extends Throwable> type) {
        if (this.actualException == null) {
            throw new AxonAssertionError("Expected exception of type " + String.valueOf(type) + " but got none");
        }
        if (!type.isInstance(this.actualException)) {
            throw new AxonAssertionError("Expected " + String.valueOf(type) + " but got " + String.valueOf(this.actualException));
        }
        return this.self();
    }

    protected boolean verifyPayloadEquality(Object expectedPayload, Object actualPayload) {
        if (Objects.equals(expectedPayload, actualPayload)) {
            return true;
        }
        if (expectedPayload != null && actualPayload == null) {
            return false;
        }
        if (expectedPayload == null) {
            return false;
        }
        if (!expectedPayload.getClass().equals(actualPayload.getClass())) {
            return false;
        }
        Matcher<Object> matcher = Matchers.deepEquals(expectedPayload, new MatchAllFieldFilter(this.customization.fieldFilters()));
        if (!matcher.matches(actualPayload)) {
            this.reporter.reportDifferentPayloads(expectedPayload.getClass(), actualPayload, expectedPayload);
        }
        return true;
    }

    protected boolean verifyMetaDataEquality(Class<?> eventType, Map<String, String> expectedMetaData, Map<String, String> actualMetaData) {
        MapStringEntryMatcher matcher = new MapStringEntryMatcher(expectedMetaData);
        if (!matcher.matches(actualMetaData)) {
            this.reporter.reportDifferentMetaData(eventType, matcher.getMissingEntries(), matcher.getAdditionalEntries());
        }
        return true;
    }

    @Override
    public AxonTestPhase.Setup and() {
        return new AxonTestFixture(this.configuration, c -> this.customization);
    }

    private T self() {
        return (T)this;
    }
}

