/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.ApplyMore;

public class StubAggregateLifecycle
extends AggregateLifecycle {
    private static final String AGGREGATE_TYPE = "stubAggregate";
    private Runnable registration;
    private final List<EventMessage<?>> appliedMessages = new CopyOnWriteArrayList();
    private boolean deleted;

    public void activate() {
        super.startScope();
        this.registration = () -> super.endScope();
    }

    public void close() {
        if (this.registration != null) {
            this.registration.run();
        }
        this.registration = null;
    }

    protected boolean getIsLive() {
        return true;
    }

    protected <T> Aggregate<T> doCreateNew(Class<T> aggregateType, Callable<T> factoryMethod) throws Exception {
        return null;
    }

    protected String type() {
        return AGGREGATE_TYPE;
    }

    protected Object identifier() {
        return IdentifierFactory.getInstance().generateIdentifier();
    }

    protected Long version() {
        return 0L;
    }

    protected void doMarkDeleted() {
        this.deleted = true;
    }

    private static <P> EventMessage<P> asEventMessage(Object event) {
        if (event instanceof EventMessage) {
            return (EventMessage)event;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage(message, () -> GenericEventMessage.clock.instant());
        }
        return new GenericEventMessage((Message)new GenericMessage(new MessageType(event.getClass()), event), () -> GenericEventMessage.clock.instant());
    }

    protected <T> ApplyMore doApply(T payload, MetaData metaData) {
        this.appliedMessages.add((EventMessage<?>)new GenericEventMessage(new MessageType(payload.getClass()), payload, (Map)metaData));
        return new ApplyMore(){

            public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
                StubAggregateLifecycle.this.appliedMessages.add(StubAggregateLifecycle.asEventMessage(payloadOrMessageSupplier.get()));
                return this;
            }

            public ApplyMore andThen(Runnable runnable) {
                runnable.run();
                return this;
            }
        };
    }

    public List<EventMessage<?>> getAppliedEvents() {
        return this.appliedMessages;
    }

    public List<Object> getAppliedEventPayloads() {
        return this.appliedMessages.stream().map(Message::getPayload).collect(Collectors.toList());
    }

    public boolean isMarkedDeleted() {
        return this.deleted;
    }
}

