/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.test.matchers.EqualsMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MapStringEntryMatcher
extends TypeSafeMatcher<Map<String, String>> {
    private final Map<Matcher<String>, Matcher<String>> matchers = new HashMap<Matcher<String>, Matcher<String>>();
    private final Map<String, String> expectedEntries;
    private final Map<String, String> additionalEntries = new HashMap<String, String>();
    private final Map<String, String> missingEntries = new HashMap<String, String>();

    public MapStringEntryMatcher(Map<String, String> expectedMap) {
        this.expectedEntries = new HashMap<String, String>(expectedMap);
        for (Map.Entry<String, String> entry : expectedMap.entrySet()) {
            this.matchers.put(EqualsMatcher.equalTo(entry.getKey()), EqualsMatcher.equalTo(entry.getValue()));
        }
    }

    protected boolean matchesSafely(Map<String, String> actualMap) {
        this.additionalEntries.clear();
        this.missingEntries.clear();
        Matching matching = new Matching(this.matchers);
        for (Map.Entry<String, String> item : actualMap.entrySet()) {
            if (matching.matches(item)) continue;
            this.additionalEntries.put(item.getKey(), item.getValue());
        }
        if (!matching.isFinished(actualMap)) {
            for (Map.Entry<String, String> item : this.expectedEntries.entrySet()) {
                if (!matching.matches(item)) continue;
                this.missingEntries.put(item.getKey(), item.getValue());
            }
            return false;
        }
        return this.additionalEntries.isEmpty();
    }

    public Map<String, String> getAdditionalEntries() {
        return Collections.unmodifiableMap(this.additionalEntries);
    }

    public Map<String, String> getMissingEntries() {
        return Collections.unmodifiableMap(this.missingEntries);
    }

    public void describeTo(Description description) {
        description.appendText("map containing ").appendValueList("[", ",", "]", this.expectedEntries.entrySet());
    }

    private record Matching(Map<Matcher<String>, Matcher<String>> matchers) {
        private Matching(Map<Matcher<String>, Matcher<String>> matchers) {
            this.matchers = new HashMap<Matcher<String>, Matcher<String>>(matchers);
        }

        public boolean matches(Map.Entry<String, String> item) {
            if (this.matchers.isEmpty()) {
                return false;
            }
            for (Map.Entry<Matcher<String>, Matcher<String>> matcherEntry : this.matchers.entrySet()) {
                if (!matcherEntry.getKey().matches((Object)item.getKey()) || !matcherEntry.getValue().matches((Object)item.getValue())) continue;
                this.matchers.remove(matcherEntry.getKey());
                return true;
            }
            return false;
        }

        public boolean isFinished(Map<String, String> items) {
            return this.matchers.isEmpty();
        }
    }
}

