/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MetaData;

public interface AxonTestPhase {

    public static interface Then {

        public static interface Message<T extends Message<T>> {
            public T events(Object ... var1);

            public T events(EventMessage<?> ... var1);

            public T eventsSatisfy(@Nonnull Consumer<List<EventMessage<?>>> var1);

            public T eventsMatch(@Nonnull Predicate<List<EventMessage<?>>> var1);

            default public T noEvents() {
                return this.events(new EventMessage[0]);
            }

            public T commands(Object ... var1);

            public T commands(CommandMessage<?> ... var1);

            public T commandsSatisfy(@Nonnull Consumer<List<CommandMessage<?>>> var1);

            public T commandsMatch(@Nonnull Predicate<List<CommandMessage<?>>> var1);

            public T noCommands();

            public T exception(@Nonnull Class<? extends Throwable> var1);

            public T exception(@Nonnull Class<? extends Throwable> var1, @Nonnull String var2);

            public T exceptionSatisfies(@Nonnull Consumer<Throwable> var1);

            public Setup and();
        }

        public static interface Event
        extends Message<Event> {
            public Event success();
        }

        public static interface Command
        extends Message<Command> {
            public Command success();

            public Command resultMessageSatisfies(@Nonnull Consumer<? super CommandResultMessage<?>> var1);

            public Command resultMessagePayload(@Nonnull Object var1);

            public Command resultMessagePayloadSatisfies(@Nonnull Consumer<Object> var1);
        }
    }

    public static interface When {
        default public Command command(@Nonnull Object payload) {
            return this.command(payload, new HashMap<String, String>());
        }

        default public Command command(@Nonnull Object payload, @Nonnull Map<String, String> metaData) {
            return this.command(payload, MetaData.from(metaData));
        }

        public Command command(@Nonnull Object var1, @Nonnull MetaData var2);

        default public Event event(@Nonnull Object payload) {
            return this.event(payload, MetaData.emptyInstance());
        }

        public Event event(@Nonnull Object var1, @Nonnull MetaData var2);

        public Event events(EventMessage<?> ... var1);

        public Event events(List<?> ... var1);

        public static interface Command {
            public Then.Command then();
        }

        public static interface Event {
            public Then.Event then();
        }
    }

    public static interface Given {
        public Given noPriorActivity();

        default public Given event(@Nonnull Object payload) {
            return this.event(payload, MetaData.emptyInstance());
        }

        default public Given event(@Nonnull Object payload, @Nonnull Map<String, String> metaData) {
            return this.event(payload, MetaData.from(metaData));
        }

        public Given event(@Nonnull Object var1, @Nonnull MetaData var2);

        public Given events(EventMessage<?> ... var1);

        default public Given events(Object ... events) {
            return this.events(Arrays.stream(events).toList());
        }

        public Given events(@Nonnull List<?> var1);

        default public Given command(@Nonnull Object payload) {
            return this.command(payload, MetaData.emptyInstance());
        }

        default public Given command(@Nonnull Object payload, @Nonnull Map<String, String> metaData) {
            return this.command(payload, MetaData.from(metaData));
        }

        public Given command(@Nonnull Object var1, @Nonnull MetaData var2);

        public Given commands(CommandMessage<?> ... var1);

        default public Given commands(Object ... commands) {
            return this.commands(Arrays.stream(commands).toList());
        }

        public Given commands(@Nonnull List<?> var1);

        public When when();
    }

    public static interface Setup {
        public Given given();

        public When when();
    }
}

